/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.application.data.difference.DifferencePeriod;
import com.agilemind.commons.application.modules.io.searchengine.data.KEI;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.field.CalculatedIntegerField;
import com.agilemind.commons.data.field.CompositTypeField;
import com.agilemind.commons.data.field.IntegerValueField;
import com.agilemind.commons.data.field.ModifiableField;
import com.agilemind.commons.data.field.RecordBeanField;
import com.agilemind.commons.data.field.StringValueField;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.io.searchengine.analyzers.analytics.GoogleAnalyticsChecker;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.Util;
import com.agilemind.ranktracker.data.AbstractKeyword;
import com.agilemind.ranktracker.data.CompareAgainst;
import com.agilemind.ranktracker.data.Competitor;
import com.agilemind.ranktracker.data.CompetitorsKeywordPositionsListMap;
import com.agilemind.ranktracker.data.ICompareAgainst;
import com.agilemind.ranktracker.data.Keyword$VisibilityScoreRecord;
import com.agilemind.ranktracker.data.KeywordDifficultyService;
import com.agilemind.ranktracker.data.KeywordPosition;
import com.agilemind.ranktracker.data.KeywordPositionsList;
import com.agilemind.ranktracker.data.KeywordVisits;
import com.agilemind.ranktracker.data.KeywordsList;
import com.agilemind.ranktracker.data.KeywordsUtil;
import com.agilemind.ranktracker.data.LandingPage;
import com.agilemind.ranktracker.data.LocalMonthlySearchesMap;
import com.agilemind.ranktracker.data.PageDifficultyData;
import com.agilemind.ranktracker.data.PageDifficultyInfoListMap;
import com.agilemind.ranktracker.data.SearchEngineKeywordPositionMap;
import com.agilemind.ranktracker.data.SearchEngineKeywordPositionsListMap;
import com.agilemind.ranktracker.data.SearchEngineResultsPageRecord;
import com.agilemind.ranktracker.data.SessionsList;
import com.agilemind.ranktracker.data.t;
import com.agilemind.ranktracker.modules.serpanalysis.data.SearchEngineSerpHistoryMap;
import com.agilemind.ranktracker.modules.serpanalysis.data.SerpHistory;
import com.agilemind.ranktracker.modules.serpanalysis.data.SerpHistoryRecord;
import com.agilemind.ranktracker.util.KeyPositionResult;
import com.agilemind.ranktracker.util.PageDifficultyDataImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class Keyword
extends AbstractKeyword {
    public static final ModifiableField<Keyword, SearchEngineKeywordPositionsListMap> PROPERTY_KEYWORD_POSITION_MAP;
    public static final ModifiableField<Keyword, CompetitorsKeywordPositionsListMap> PROPERTY_COMPETITORS_POSITION_MAP;
    public static final IntegerValueField<Keyword> SESSIONS_COUNT_FIELD;
    public static final StringValueField<Keyword> PROPERTY_KEY_NOTES;
    public static final ModifiableField<Keyword, LandingPage> LANDING_PAGE;
    public static final CompositTypeField<Keyword, LandingPage, UnicodeURL> LANDING_PAGE_URL;
    public static final ModifiableField<Keyword, SearchEngineSerpHistoryMap> SERP_HISTORY_MAP;
    private static final ModifiableField<Keyword, KeywordVisits> d;
    private static final ModifiableField<Keyword, PageDifficultyInfoListMap> e;
    private static final ModifiableField<Keyword, LocalMonthlySearchesMap> f;
    @Deprecated
    private static final ModifiableField<Keyword, SearchEngineKeywordPositionMap> g;
    @Deprecated
    private static final IntegerValueField<Keyword> h;
    public static final CalculatedIntegerField<Keyword> SESSIONS_PER_MONTH_COUNT;
    public static final CompositTypeField<Keyword, KeywordVisits, Double> KEYWORD_BOUNCE_RATES;
    public static boolean i;
    private static final String[] j;

    public Keyword(Database database, Identifier identifier) {
        super(database, identifier);
    }

    Keyword(KeywordsList keywordsList, String string) {
        super((Record)keywordsList, string);
        this.set((RecordBeanField)PROPERTY_KEYWORD_POSITION_MAP, (Object)new SearchEngineKeywordPositionsListMap((Record)this));
        this.set((RecordBeanField)PROPERTY_COMPETITORS_POSITION_MAP, (Object)new CompetitorsKeywordPositionsListMap(this));
        this.set((RecordBeanField)KEI_FIELD, new KEI((Record)this));
        this.set((RecordBeanField)d, (Object)new KeywordVisits((Record)this));
        this.set((RecordBeanField)f, (Object)new LocalMonthlySearchesMap((Record)this));
    }

    public void recordLoaded() throws IOException {
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap;
        super.recordLoaded();
        if (this.get((RecordBeanField)TAGS_FIELD) == null) {
            this.set((RecordBeanField)TAGS_FIELD, "");
        }
        if (this.get((RecordBeanField)KEI_FIELD) == null) {
            this.set((RecordBeanField)KEI_FIELD, new KEI((Record)this));
        }
        SearchEngineKeywordPositionMap searchEngineKeywordPositionMap = (SearchEngineKeywordPositionMap)((Object)this.get((RecordBeanField)g));
        if (searchEngineKeywordPositionMap != null) {
            searchEngineKeywordPositionsListMap = new SearchEngineKeywordPositionsListMap(this, searchEngineKeywordPositionMap);
            this.set((RecordBeanField)PROPERTY_KEYWORD_POSITION_MAP, (Object)searchEngineKeywordPositionsListMap);
            this.set((RecordBeanField)g, null);
        }
        if (this.get((RecordBeanField)PROPERTY_KEYWORD_POSITION_MAP) == null) {
            searchEngineKeywordPositionsListMap = new SearchEngineKeywordPositionsListMap((Record)this);
            this.set((RecordBeanField)PROPERTY_KEYWORD_POSITION_MAP, (Object)searchEngineKeywordPositionsListMap);
        }
        if (this.get((RecordBeanField)PROPERTY_COMPETITORS_POSITION_MAP) == null) {
            this.set((RecordBeanField)PROPERTY_COMPETITORS_POSITION_MAP, (Object)new CompetitorsKeywordPositionsListMap(this));
        }
        if (this.get((RecordBeanField)d) == null) {
            this.set((RecordBeanField)d, (Object)new KeywordVisits((Record)this));
        }
        if (this.get((RecordBeanField)SESSIONS_COUNT_FIELD) != null) {
            this.set((RecordBeanField)SESSIONS_COUNT_FIELD, null);
        }
        if (this.get((RecordBeanField)f) == null) {
            this.set((RecordBeanField)f, (Object)new LocalMonthlySearchesMap((Record)this));
        }
    }

    public void addPositions(SearchEngineType searchEngineType, List<KeyPositionResult> list) {
        SearchEngineResultsPageRecord searchEngineResultsPageRecord;
        KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
        if (keywordPositionsList == null) {
            keywordPositionsList = new KeywordPositionsList((Record)this);
            this.getSearchEngineKeywordPositionMap().put(searchEngineType, (Object)keywordPositionsList);
        }
        KeywordPosition keywordPosition = keywordPositionsList.a(list);
        PageDifficultyInfoListMap pageDifficultyInfoListMap = (PageDifficultyInfoListMap)((Object)this.get((RecordBeanField)e));
        if (pageDifficultyInfoListMap != null && (searchEngineResultsPageRecord = (SearchEngineResultsPageRecord)pageDifficultyInfoListMap.get(searchEngineType)) != null) {
            PageDifficultyData pageDifficultyData = searchEngineResultsPageRecord.getFoundPageDifficultyData();
            UnicodeURL unicodeURL = keywordPosition.getUrl();
            if (pageDifficultyData == null || !Util.equals((Object)pageDifficultyData.getPageUrl(), (Object)unicodeURL)) {
                searchEngineResultsPageRecord.b(new PageDifficultyDataImpl(unicodeURL, keywordPosition));
            }
        }
    }

    public KeywordPosition addPosition(Competitor competitor, SearchEngineType searchEngineType, List<KeyPositionResult> list) {
        KeywordPositionsList keywordPositionsList = this.getCompetitorKeywordPositionsList(competitor, searchEngineType);
        keywordPositionsList = this.a(competitor, searchEngineType, keywordPositionsList);
        return keywordPositionsList.a(list);
    }

    private KeywordPositionsList a(Competitor competitor, SearchEngineType searchEngineType, KeywordPositionsList keywordPositionsList) {
        if (keywordPositionsList == null) {
            keywordPositionsList = new KeywordPositionsList((Record)this);
            SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getCompetitorKeywordPositionsListMap(competitor);
            if (searchEngineKeywordPositionsListMap == null) {
                searchEngineKeywordPositionsListMap = new SearchEngineKeywordPositionsListMap((Record)this);
                this.getCompetitorsKeywordPositionMap().put(competitor, (Object)searchEngineKeywordPositionsListMap);
            }
            searchEngineKeywordPositionsListMap.put(searchEngineType, (Object)keywordPositionsList);
        }
        return keywordPositionsList;
    }

    public SearchEngineKeywordPositionsListMap getSearchEngineKeywordPositionMap() {
        return (SearchEngineKeywordPositionsListMap)((Object)this.get((RecordBeanField)PROPERTY_KEYWORD_POSITION_MAP));
    }

    public CompetitorsKeywordPositionsListMap getCompetitorsKeywordPositionMap() {
        return (CompetitorsKeywordPositionsListMap)((Object)this.get((RecordBeanField)PROPERTY_COMPETITORS_POSITION_MAP));
    }

    @Nullable
    public KeywordPosition getPosition(SearchEngineType searchEngineType) {
        KeywordPositionsList keywordPositionsList = (KeywordPositionsList)((Object)this.getSearchEngineKeywordPositionMap().get(searchEngineType));
        return keywordPositionsList != null ? keywordPositionsList.getPosition() : null;
    }

    @Nullable
    public KeywordPosition getPosition(SearchEngineType searchEngineType, Competitor competitor) {
        KeywordPositionsList keywordPositionsList = this.getHistory(searchEngineType, competitor);
        return keywordPositionsList != null ? keywordPositionsList.getPosition() : null;
    }

    public KeywordPosition getLastPosition(SearchEngineType searchEngineType) {
        return this.getHistory(searchEngineType).getLastPosition();
    }

    public KeywordPositionsList getHistory(SearchEngineType searchEngineType) {
        return this.getSearchEngineKeywordPositionMap().getOrCreate(searchEngineType);
    }

    public KeywordPositionsList getHistory(SearchEngineType searchEngineType, Competitor competitor) {
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getCompetitorKeywordPositionsListMap(competitor);
        if (searchEngineKeywordPositionsListMap != null) {
            return (KeywordPositionsList)((Object)searchEngineKeywordPositionsListMap.get(searchEngineType));
        }
        return null;
    }

    @Nullable
    public KeywordPositionsList getKeywordPositionsList(SearchEngineType searchEngineType) {
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        return (KeywordPositionsList)((Object)searchEngineKeywordPositionsListMap.get(searchEngineType));
    }

    public KeywordPositionsList getOrCreateKeywordPositionsList(SearchEngineType searchEngineType) {
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        return searchEngineKeywordPositionsListMap.getOrCreate(searchEngineType);
    }

    @Nullable
    public SearchEngineKeywordPositionsListMap getCompetitorKeywordPositionsListMap(Competitor competitor) {
        CompetitorsKeywordPositionsListMap competitorsKeywordPositionsListMap = this.getCompetitorsKeywordPositionMap();
        return (SearchEngineKeywordPositionsListMap)((Object)competitorsKeywordPositionsListMap.get(competitor));
    }

    @Nullable
    public KeywordPositionsList getCompetitorKeywordPositionsList(Competitor competitor, SearchEngineType searchEngineType) {
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getCompetitorKeywordPositionsListMap(competitor);
        return searchEngineKeywordPositionsListMap == null ? null : (KeywordPositionsList)((Object)searchEngineKeywordPositionsListMap.get(searchEngineType));
    }

    @Nullable
    public Map<SearchEngineType, SerpHistory> getSerpHistoryMap() {
        SearchEngineSerpHistoryMap searchEngineSerpHistoryMap = (SearchEngineSerpHistoryMap)((Object)this.get((RecordBeanField)SERP_HISTORY_MAP));
        return searchEngineSerpHistoryMap != null ? searchEngineSerpHistoryMap.getMap() : null;
    }

    public SerpHistory getSerpHistory(SearchEngineType searchEngineType) {
        SearchEngineSerpHistoryMap searchEngineSerpHistoryMap = (SearchEngineSerpHistoryMap)((Object)this.get((RecordBeanField)SERP_HISTORY_MAP));
        return searchEngineSerpHistoryMap != null ? (SerpHistory)searchEngineSerpHistoryMap.get(searchEngineType) : null;
    }

    public void addSerpHistory(SearchEngineType searchEngineType, Date date, List<SerpHistoryRecord> list) {
        SearchEngineSerpHistoryMap searchEngineSerpHistoryMap = (SearchEngineSerpHistoryMap)((Object)this.get((RecordBeanField)SERP_HISTORY_MAP));
        if (searchEngineSerpHistoryMap == null) {
            searchEngineSerpHistoryMap = new SearchEngineSerpHistoryMap((Record)this);
            this.set((RecordBeanField)SERP_HISTORY_MAP, (Object)searchEngineSerpHistoryMap);
        }
        searchEngineSerpHistoryMap.addHistoryRecords(searchEngineType, date, list);
    }

    public void removeSerpHistory(SearchEngineType searchEngineType, Date date) {
        SearchEngineSerpHistoryMap searchEngineSerpHistoryMap = (SearchEngineSerpHistoryMap)((Object)this.get((RecordBeanField)SERP_HISTORY_MAP));
        if (searchEngineSerpHistoryMap != null) {
            searchEngineSerpHistoryMap.removeHistoryRecords(searchEngineType, date);
        }
    }

    public void removeSerpHistory(SearchEngineType searchEngineType, Date date, Date date2) {
        SearchEngineSerpHistoryMap searchEngineSerpHistoryMap = (SearchEngineSerpHistoryMap)((Object)this.get((RecordBeanField)SERP_HISTORY_MAP));
        if (searchEngineSerpHistoryMap != null) {
            searchEngineSerpHistoryMap.removeHistoryRecords(searchEngineType, date, date2);
        }
    }

    public String getNotes() {
        return (String)this.get((RecordBeanField)PROPERTY_KEY_NOTES);
    }

    public void setNotes(String string) {
        this.set((RecordBeanField)PROPERTY_KEY_NOTES, string);
    }

    public LandingPage getLandingPage() {
        return (LandingPage)this.get((RecordBeanField)LANDING_PAGE);
    }

    public void setLandingUrl(UnicodeURL unicodeURL, int n2, boolean bl, boolean bl2) {
        LandingPage landingPage = this.getLandingPage();
        UnicodeURL unicodeURL2 = landingPage.getUrl();
        landingPage.a(unicodeURL);
        if (unicodeURL2 == null && unicodeURL != null) {
            this.a(landingPage, n2, bl);
        }
        if (unicodeURL2 != null && !unicodeURL2.equals((Object)unicodeURL)) {
            this.a(landingPage, n2, bl);
        }
        if (!landingPage.isEnable() && bl2) {
            this.setLandingEnable(true, n2, bl);
        }
    }

    public void setLandingEnable(boolean bl, int n2, boolean bl2) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.a(this.getLandingPage(), n2, bl2);
                if (!AbstractKeyword.c) break block3;
            }
            this.n();
        }
    }

    public LandingPage initLandingPage() {
        LandingPage landingPage = new LandingPage(this);
        this.set((RecordBeanField)LANDING_PAGE, landingPage);
        return landingPage;
    }

    public void clearLandingPage() {
        this.set((RecordBeanField)LANDING_PAGE, null);
        this.n();
    }

    private void a(LandingPage landingPage, int n2, boolean bl) {
        boolean bl2 = AbstractKeyword.c;
        PageDifficultyInfoListMap pageDifficultyInfoListMap = this.getKeywordDifficultyMap();
        if (pageDifficultyInfoListMap == null) {
            return;
        }
        for (SearchEngineType searchEngineType : pageDifficultyInfoListMap.keySet()) {
            SearchEngineResultsPageRecord searchEngineResultsPageRecord = (SearchEngineResultsPageRecord)pageDifficultyInfoListMap.get(searchEngineType);
            if (searchEngineResultsPageRecord != null && landingPage.isEnable()) {
                searchEngineResultsPageRecord.a(new PageDifficultyDataImpl(landingPage.getUrl(), KeywordDifficultyService.calcLandingPosition(n2, this, searchEngineType, bl)));
            }
            if (!bl2) continue;
        }
    }

    private void n() {
        boolean bl = AbstractKeyword.c;
        PageDifficultyInfoListMap pageDifficultyInfoListMap = this.getKeywordDifficultyMap();
        if (pageDifficultyInfoListMap == null) {
            return;
        }
        for (SearchEngineType searchEngineType : pageDifficultyInfoListMap.keySet()) {
            SearchEngineResultsPageRecord searchEngineResultsPageRecord = (SearchEngineResultsPageRecord)pageDifficultyInfoListMap.get(searchEngineType);
            if (searchEngineResultsPageRecord != null) {
                searchEngineResultsPageRecord.a((PageDifficultyData)null);
            }
            if (!bl) continue;
        }
    }

    public LocalMonthlySearchesMap getLocalMonthlySearchesMap() {
        return (LocalMonthlySearchesMap)((Object)this.get((RecordBeanField)f));
    }

    public boolean isInTop(SearchEngineType searchEngineType, int n2) {
        KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
        if (keywordPositionsList == null) {
            return false;
        }
        KeywordPosition keywordPosition = keywordPositionsList.getPosition();
        return keywordPosition != null && keywordPosition.getPosition() <= n2;
    }

    public boolean isNonInTop(SearchEngineType searchEngineType, int n2) {
        return this.isNonInTop(searchEngineType, null, n2);
    }

    public boolean isNonInTop(SearchEngineType searchEngineType, @Nullable Competitor competitor, int n2) {
        return this.isNonInTop(CompareAgainst.CURRENT_MEASUREMENT, searchEngineType, competitor, n2);
    }

    public boolean isNonInTop(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType, @Nullable Competitor competitor, int n2) {
        KeywordPositionsList keywordPositionsList;
        KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? this.getKeywordPositionsList(searchEngineType) : this.getCompetitorKeywordPositionsList(competitor, searchEngineType);
        if (keywordPositionsList == null) {
            return false;
        }
        KeywordPosition keywordPosition = keywordPositionsList.getPosition(iCompareAgainst);
        return keywordPosition != null && keywordPosition.getPosition() > n2;
    }

    public boolean isInTop(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType, int n2) {
        KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
        if (keywordPositionsList == null) {
            return false;
        }
        KeywordPosition keywordPosition = keywordPositionsList.getPosition(iCompareAgainst);
        return keywordPosition != null && keywordPosition.getPosition() <= n2;
    }

    public boolean isInTop(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType, int n2, @Nullable Competitor competitor) {
        KeywordPositionsList keywordPositionsList;
        KeywordPositionsList keywordPositionsList2 = keywordPositionsList = competitor == null ? this.getKeywordPositionsList(searchEngineType) : this.getCompetitorKeywordPositionsList(competitor, searchEngineType);
        if (keywordPositionsList == null) {
            return false;
        }
        KeywordPosition keywordPosition = keywordPositionsList.getPosition(iCompareAgainst);
        return keywordPosition != null && keywordPosition.getPosition() <= n2;
    }

    public int getInTop(Iterable<SearchEngineType> iterable, int n2) {
        boolean bl = AbstractKeyword.c;
        int n3 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            if (this.isInTop(searchEngineType, n2)) {
                ++n3;
            }
            if (!bl) continue;
        }
        return n3;
    }

    public int getNonInTop(Iterable<SearchEngineType> iterable, int n2) {
        return this.getNonInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, null, n2);
    }

    public int getNonInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        boolean bl = AbstractKeyword.c;
        int n3 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            if (this.isNonInTop(iCompareAgainst, searchEngineType, competitor, n2)) {
                ++n3;
            }
            if (!bl) continue;
        }
        return n3;
    }

    public int getNonInTopDifference(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        return this.getNonInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, competitor, n2) - this.getNonInTop(iCompareAgainst, iterable, competitor, n2);
    }

    public int getInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2) {
        boolean bl = AbstractKeyword.c;
        int n3 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            if (this.isInTop(iCompareAgainst, searchEngineType, n2)) {
                ++n3;
            }
            if (!bl) continue;
        }
        return n3;
    }

    public int getInTopDifference(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2) {
        return this.getInTopDifference(iCompareAgainst, iterable, null, n2);
    }

    public int getInTopDifference(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, @Nullable Competitor competitor, int n2) {
        return this.getInTop(ICompareAgainst.CURRENT_MEASUREMENT, iterable, n2, competitor) - this.getInTop(iCompareAgainst, iterable, n2, competitor);
    }

    public int getInTop(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, int n2, Competitor competitor) {
        boolean bl = AbstractKeyword.c;
        int n3 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            if (this.isInTop(iCompareAgainst, searchEngineType, n2, competitor)) {
                ++n3;
            }
            if (!bl) continue;
        }
        return n3;
    }

    @Deprecated
    public int getVisibilityScore(Iterable<SearchEngineType> iterable) {
        return this.getVisibilityScore(ICompareAgainst.CURRENT_MEASUREMENT, iterable);
    }

    public int getVisibilityScore(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable) {
        boolean bl = AbstractKeyword.c;
        int n2 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            n2 += this.getVisibilityScore(iCompareAgainst, searchEngineType);
            if (!bl) continue;
        }
        return n2;
    }

    public int getVisibilityScoreComp(ICompareAgainst iCompareAgainst, Iterable<SearchEngineType> iterable, Competitor competitor) {
        boolean bl = AbstractKeyword.c;
        int n2 = 0;
        for (SearchEngineType searchEngineType : iterable) {
            n2 += this.getVisibilityScoreComp(iCompareAgainst, searchEngineType, competitor);
            if (!bl) continue;
        }
        return n2;
    }

    public int getVisibilityScoreDifference(ICompareAgainst iCompareAgainst, ICompareAgainst iCompareAgainst2, Iterable<SearchEngineType> iterable) {
        int n2 = this.getVisibilityScore(iCompareAgainst, iterable);
        int n3 = this.getVisibilityScore(iCompareAgainst2, iterable);
        return n2 - n3;
    }

    public int getVisibilityScoreDifference(ICompareAgainst iCompareAgainst, ICompareAgainst iCompareAgainst2, Iterable<SearchEngineType> iterable, Competitor competitor) {
        int n2 = this.getVisibilityScoreComp(iCompareAgainst, iterable, competitor);
        int n3 = this.getVisibilityScoreComp(iCompareAgainst2, iterable, competitor);
        return n2 - n3;
    }

    @Deprecated
    public int getVisibilityScore(SearchEngineType searchEngineType) {
        return this.getVisibilityScore(ICompareAgainst.CURRENT_MEASUREMENT, searchEngineType);
    }

    public int getVisibilityScore(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType) {
        int n2 = 0;
        KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
        return this.a(iCompareAgainst, n2, keywordPositionsList);
    }

    public int getVisibilityScoreComp(ICompareAgainst iCompareAgainst, SearchEngineType searchEngineType, Competitor competitor) {
        int n2 = 0;
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getCompetitorKeywordPositionsListMap(competitor);
        if (searchEngineKeywordPositionsListMap == null) {
            return 0;
        }
        KeywordPositionsList keywordPositionsList = (KeywordPositionsList)((Object)searchEngineKeywordPositionsListMap.get(searchEngineType));
        return this.a(iCompareAgainst, n2, keywordPositionsList);
    }

    private int a(ICompareAgainst iCompareAgainst, int n2, KeywordPositionsList keywordPositionsList) {
        KeywordPosition keywordPosition;
        if (keywordPositionsList != null && (keywordPosition = keywordPositionsList.getPosition(iCompareAgainst)) != null) {
            int n3 = keywordPosition.getPosition();
            n2 = KeywordsUtil.getVisibilityScore(n3);
        }
        return n2;
    }

    public void getVisibilityPercentMap(Map<Date, Keyword$VisibilityScoreRecord> map, List<SearchEngineType> list) {
        this.getVisibilityPercentMap(map, list, null);
    }

    public void getVisibilityPercentMap(Map<Date, Keyword$VisibilityScoreRecord> map, Collection<SearchEngineType> collection, @Nullable Competitor competitor) {
        boolean bl = AbstractKeyword.c;
        for (SearchEngineType searchEngineType : collection) {
            block4: {
                KeywordPositionsList keywordPositionsList;
                block3: {
                    keywordPositionsList = this.a(searchEngineType, competitor);
                    if (keywordPositionsList != null && !keywordPositionsList.isEmpty()) break block3;
                    Keyword.a(map);
                    if (!bl) break block4;
                }
                Keyword.a(map, keywordPositionsList);
            }
            if (!bl) continue;
        }
    }

    public XYDataset<Integer> getVisibilityPercentMap(List<SearchEngineType> list) {
        boolean bl = AbstractKeyword.c;
        TreeMap<Date, Keyword$VisibilityScoreRecord> treeMap = new TreeMap<Date, Keyword$VisibilityScoreRecord>();
        this.a(treeMap, list);
        this.getVisibilityPercentMap(treeMap, list);
        XYDataset xYDataset = new XYDataset();
        for (Map.Entry entry : treeMap.entrySet()) {
            xYDataset.put(entry.getKey(), (Object)((Keyword$VisibilityScoreRecord)entry.getValue()).getPercent());
            if (!bl) continue;
        }
        return xYDataset;
    }

    private KeywordPositionsList a(SearchEngineType searchEngineType, Competitor competitor) {
        block5: {
            block4: {
                if (competitor == null) break block4;
                SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getCompetitorKeywordPositionsListMap(competitor);
                if (searchEngineKeywordPositionsListMap != null) {
                    return (KeywordPositionsList)((Object)searchEngineKeywordPositionsListMap.get(searchEngineType));
                }
                if (!AbstractKeyword.c) break block5;
            }
            return this.getKeywordPositionsList(searchEngineType);
        }
        return null;
    }

    private static void a(Map<Date, Keyword$VisibilityScoreRecord> map, KeywordPositionsList keywordPositionsList) {
        boolean bl = AbstractKeyword.c;
        int n2 = 31;
        HashMap<Date, KeywordPosition> hashMap = new HashMap<Date, KeywordPosition>();
        Iterator<Map.Entry<Date, Keyword$VisibilityScoreRecord>> iterator = keywordPositionsList.iterator();
        while (iterator.hasNext()) {
            KeywordPosition object = (KeywordPosition)iterator.next();
            hashMap.put(DateUtil.getStartDay((Date)object.getCheckDate()), object);
            if (!bl) continue;
        }
        for (Map.Entry<Date, Keyword$VisibilityScoreRecord> entry : map.entrySet()) {
            block5: {
                Keyword$VisibilityScoreRecord keyword$VisibilityScoreRecord;
                block4: {
                    keyword$VisibilityScoreRecord = entry.getValue();
                    KeywordPosition keywordPosition = (KeywordPosition)hashMap.get(entry.getKey());
                    if (keywordPosition == null) break block4;
                    n2 = keywordPosition.getPosition();
                    Keyword.a(keyword$VisibilityScoreRecord, n2);
                    if (!bl) break block5;
                }
                Keyword.a(keyword$VisibilityScoreRecord, n2);
            }
            if (!bl) continue;
        }
    }

    private static void a(Map<Date, Keyword$VisibilityScoreRecord> map) {
        boolean bl = AbstractKeyword.c;
        for (Keyword$VisibilityScoreRecord keyword$VisibilityScoreRecord : map.values()) {
            keyword$VisibilityScoreRecord.updateVisibilityScore(0);
            if (!bl) continue;
        }
    }

    private static void a(Keyword$VisibilityScoreRecord keyword$VisibilityScoreRecord, int n2) {
        keyword$VisibilityScoreRecord.updateVisibilityScore(KeywordsUtil.getVisibilityScore(n2));
    }

    public Date getLastCheckTime() {
        boolean bl = AbstractKeyword.c;
        Date date = null;
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        for (SearchEngineType searchEngineType : searchEngineKeywordPositionsListMap.keySet()) {
            KeywordPosition keywordPosition;
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null && (keywordPosition = keywordPositionsList.getPosition()) != null) {
                Date date2 = keywordPosition.getCheckDate();
                if (date == null || date2.after(date)) {
                    date = date2;
                }
            }
            if (!bl) continue;
        }
        return date;
    }

    public void setKeywordVisits(Map<Date, Integer> map) {
        boolean bl = AbstractKeyword.c;
        KeywordVisits keywordVisits = this.getKeywordVisits();
        Date date = keywordVisits.getLastCheckDate();
        if (date == null) {
            return;
        }
        Calendar calendar = DateUtil.getStartCalendar((Date)date);
        calendar.add(5, -1);
        Date date2 = calendar.getTime();
        SessionsList sessionsList = keywordVisits.getVisitsList();
        for (int i2 = sessionsList.size() - 1; i2 >= Math.max(sessionsList.size() - 31, 0); --i2) {
            Integer n2;
            block6: {
                int n3;
                block5: {
                    n3 = (Integer)sessionsList.get(i2);
                    n2 = map.get(calendar.getTime());
                    if (n2 == null) break block5;
                    n2 = n2 + n3;
                    if (!bl) break block6;
                }
                n2 = n3;
            }
            map.put(date2, n2);
            calendar.add(5, -1);
            date2 = calendar.getTime();
            if (!bl) continue;
        }
    }

    public Map.Entry<Date, Integer> getVisitsDifferenceValue(DifferencePeriod<Map.Entry<Date, Integer>, Map<Date, Integer>> differencePeriod) {
        TreeMap<Date, Integer> treeMap = new TreeMap<Date, Integer>();
        this.setKeywordVisits(treeMap);
        return (Map.Entry)differencePeriod.getValue(treeMap);
    }

    public int getDropOrAddTop(ICompareAgainst iCompareAgainst, boolean bl, int n2) {
        boolean bl2 = AbstractKeyword.c;
        int n3 = 0;
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        for (SearchEngineType searchEngineType : searchEngineKeywordPositionsListMap.keySet()) {
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null && keywordPositionsList.isDropOrAddTop(iCompareAgainst, bl, n2)) {
                ++n3;
            }
            if (!bl2) continue;
        }
        return n3;
    }

    public int getMovedUpOrDown(ICompareAgainst iCompareAgainst, boolean bl) {
        boolean bl2 = AbstractKeyword.c;
        int n2 = 0;
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        for (SearchEngineType searchEngineType : searchEngineKeywordPositionsListMap.keySet()) {
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null && keywordPositionsList.getMovedUpOrDown(iCompareAgainst, bl)) {
                ++n2;
            }
            if (!bl2) continue;
        }
        return n2;
    }

    public List<String> getSearchEnginesMovedUpOrDown(ICompareAgainst iCompareAgainst, boolean bl) {
        boolean bl2 = AbstractKeyword.c;
        ArrayList<String> arrayList = new ArrayList<String>();
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        for (SearchEngineType searchEngineType : searchEngineKeywordPositionsListMap.keySet()) {
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null && keywordPositionsList.getMovedUpOrDown(iCompareAgainst, bl)) {
                arrayList.add(searchEngineType.getType());
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    public int getRanked() {
        boolean bl = AbstractKeyword.c;
        int n2 = 0;
        SearchEngineKeywordPositionsListMap searchEngineKeywordPositionsListMap = this.getSearchEngineKeywordPositionMap();
        for (SearchEngineType searchEngineType : searchEngineKeywordPositionsListMap.keySet()) {
            KeywordPosition keywordPosition;
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null && (keywordPosition = keywordPositionsList.getPosition()) != null && !keywordPosition.isPositionNotFound()) {
                ++n2;
            }
            if (!bl) continue;
        }
        return n2;
    }

    void a(Map<Date, Keyword$VisibilityScoreRecord> map, Collection<SearchEngineType> collection) {
        boolean bl = AbstractKeyword.c;
        Calendar calendar = Calendar.getInstance();
        for (SearchEngineType searchEngineType : collection) {
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList == null && !bl) continue;
            Iterator iterator = keywordPositionsList.iterator();
            while (iterator.hasNext()) {
                KeywordPosition keywordPosition = (KeywordPosition)iterator.next();
                DateUtil.setStartDayCalendar((Calendar)calendar, (Date)keywordPosition.getCheckDate());
                map.putIfAbsent(calendar.getTime(), new Keyword$VisibilityScoreRecord());
                if (!bl) continue;
            }
            if (!bl) continue;
        }
    }

    public ArrayList<Date> getDates(List<SearchEngineType> list) {
        boolean bl = AbstractKeyword.c;
        ArrayList<Date> arrayList = new ArrayList<Date>();
        for (SearchEngineType searchEngineType : list) {
            KeywordPositionsList keywordPositionsList = this.getKeywordPositionsList(searchEngineType);
            if (keywordPositionsList != null) {
                Iterator iterator = keywordPositionsList.iterator();
                while (iterator.hasNext()) {
                    KeywordPosition keywordPosition = (KeywordPosition)iterator.next();
                    Date date = DateUtil.getStartDay((Date)keywordPosition.getCheckDate());
                    arrayList.add(date);
                    if (!bl) continue;
                }
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public List<XYDataset<Integer>> getSeriesDatasets(SearchEngineType searchEngineType, List<Competitor> list) {
        boolean bl = AbstractKeyword.c;
        ArrayList<XYDataset<Integer>> arrayList = new ArrayList<XYDataset<Integer>>();
        for (Competitor competitor : list) {
            XYDataset xYDataset;
            block4: {
                block3: {
                    KeywordPositionsList keywordPositionsList = this.getCompetitorKeywordPositionsList(competitor, searchEngineType);
                    if (keywordPositionsList == null) break block3;
                    xYDataset = keywordPositionsList.getSeriesDataset();
                    if (!bl) break block4;
                }
                xYDataset = new XYDataset();
            }
            xYDataset.setName(competitor.getShortName());
            xYDataset.setColor(competitor.getKeywordColor());
            arrayList.add((XYDataset<Integer>)xYDataset);
            if (!bl) continue;
        }
        return arrayList;
    }

    public KeywordVisits getKeywordVisits() {
        return (KeywordVisits)((Object)this.get((RecordBeanField)d));
    }

    public int getVisits() {
        return Keyword.a(this);
    }

    public double getReach() {
        KEI kEI = this.getKEI();
        int n2 = this.getVisits();
        return Keyword.a(n2, kEI);
    }

    @Nullable
    public PageDifficultyInfoListMap getKeywordDifficultyMap() {
        return (PageDifficultyInfoListMap)((Object)this.get((RecordBeanField)e));
    }

    public void setKeywordDifficultyMap(PageDifficultyInfoListMap pageDifficultyInfoListMap) {
        this.set((RecordBeanField)e, (Object)pageDifficultyInfoListMap);
    }

    private static Integer a(Keyword keyword) {
        SessionsList sessionsList;
        int n2;
        KeywordVisits keywordVisits;
        boolean bl = AbstractKeyword.c;
        int n3 = GoogleAnalyticsChecker.NOT_YET_CHECKED;
        if (keyword != null && (keywordVisits = keyword.getKeywordVisits()) != null && (n2 = (sessionsList = keywordVisits.getVisitsList()).size()) > 0) {
            n3 = 0;
            for (int i2 = sessionsList.size() - 1; i2 >= Math.max(sessionsList.size() - 31, 0); --i2) {
                n3 += ((Integer)sessionsList.get(i2)).intValue();
                if (!bl) continue;
            }
        }
        return n3;
    }

    private static double a(long l2, KEI kEI) {
        double d2;
        block3: {
            long l3;
            block5: {
                boolean bl;
                block4: {
                    block2: {
                        bl = AbstractKeyword.c;
                        l3 = kEI.getSearchNum();
                        if (l3 != -2L && l2 != (long)GoogleAnalyticsChecker.NOT_YET_CHECKED.intValue()) break block2;
                        d2 = -2.0;
                        if (!bl) break block3;
                    }
                    if (l2 != 0L) break block4;
                    d2 = 0.0;
                    if (!bl) break block3;
                }
                if (l3 != 0L && l3 != -1L && l3 != -3L) break block5;
                d2 = -1.0;
                if (!bl) break block3;
            }
            long l4 = kEI.getKeywordCollectorType().getMonthlySearchNum(l3);
            d2 = (double)(l2 * 100L) / (double)l4;
        }
        return d2;
    }

    static Integer b(Keyword keyword) {
        return Keyword.a(keyword);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0002 _>(\u001b!v&4\u00001O&)%,U=\n\b5";
        int n3 = -1;
        block19: while (true) {
            char[] cArray;
            block24: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block23: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block23;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block24;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 105;
                                break;
                            }
                            case 1: {
                                n9 = 69;
                                break;
                            }
                            case 2: {
                                n9 = 38;
                                break;
                            }
                            case 3: {
                                n9 = 73;
                                break;
                            }
                            default: {
                                n9 = 71;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u00063C;3\u001c7C\u001a\"\b7E!\t\u001c(";
                    n3 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0002 _>(\u001b!b !\u000f,E<+\u001d<k(7";
                    n3 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0005*E(+: G;$\u0001 U\u0004&\u0019";
                    n3 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0005$H-.\u0007\"v( \f";
                    n3 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001a T9\u000f\u00006R&5\u0010\bG9";
                    n3 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001f,U 3\u001a\u000bS$";
                    n3 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0002 _>(\u001b!v&4\u00001O&)$$V";
                    n3 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001f,U 3\u001a\u000bS$";
                    n3 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\n*K9\"\u001d,R&5\u001a\u0015I:.\u001d,I'\u000b\u00006R\u0004&\u0019";
                    n3 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0007*R,4";
                    n3 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0002 _>(\u001b!p 4\u00001U";
                    n3 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        j = stringArray3;
        PROPERTY_KEYWORD_POSITION_MAP = new ModifiableField(j[0], Keyword.class, SearchEngineKeywordPositionsListMap.class);
        PROPERTY_COMPETITORS_POSITION_MAP = new ModifiableField(j[9], Keyword.class, CompetitorsKeywordPositionsListMap.class);
        SESSIONS_COUNT_FIELD = new IntegerValueField(j[8], Keyword.class, null);
        PROPERTY_KEY_NOTES = new StringValueField(j[10], Keyword.class);
        LANDING_PAGE = new ModifiableField(j[4], Keyword.class, LandingPage.class);
        LANDING_PAGE_URL = new CompositTypeField(LANDING_PAGE, LandingPage.URL_PROPERTY);
        SERP_HISTORY_MAP = new ModifiableField(j[5], Keyword.class, SearchEngineSerpHistoryMap.class);
        d = new ModifiableField(j[11], Keyword.class, KeywordVisits.class);
        e = new ModifiableField(j[2], Keyword.class, PageDifficultyInfoListMap.class);
        f = new ModifiableField(j[3], Keyword.class, LocalMonthlySearchesMap.class);
        g = new ModifiableField(j[7], Keyword.class, SearchEngineKeywordPositionMap.class);
        h = new IntegerValueField(j[1], Keyword.class);
        SESSIONS_PER_MONTH_COUNT = new t(j[6]);
        KEYWORD_BOUNCE_RATES = new CompositTypeField(d, KeywordVisits.KEYWORD_BOUNCE_RATE_FIELD);
    }
}

