/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.data.Record;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.ranktracker.data.AbstractKeyword;
import com.agilemind.ranktracker.data.IPosition;
import com.agilemind.ranktracker.data.Keyword;
import com.agilemind.ranktracker.data.KeywordPosition;
import com.agilemind.ranktracker.data.L;
import com.agilemind.ranktracker.data.LandingPage;
import com.agilemind.ranktracker.data.MultipleKeywordPosition;
import com.agilemind.ranktracker.data.MultipleKeywordPositionsList;
import com.agilemind.ranktracker.data.PageDifficultyData;
import com.agilemind.ranktracker.data.PageDifficultyInfoListMap;
import com.agilemind.ranktracker.data.Position;
import com.agilemind.ranktracker.data.SearchEngineResultsPage;
import com.agilemind.ranktracker.data.SearchEngineResultsPageRecord;
import com.agilemind.ranktracker.util.PageDifficultyCollection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class KeywordDifficultyService {
    @Nullable
    public static SearchEngineResultsPage getSearchEngineResultsPage(Keyword keyword, SearchEngineType searchEngineType) {
        PageDifficultyInfoListMap pageDifficultyInfoListMap = keyword.getKeywordDifficultyMap();
        if (pageDifficultyInfoListMap == null) {
            return null;
        }
        SearchEngineResultsPageRecord searchEngineResultsPageRecord = (SearchEngineResultsPageRecord)pageDifficultyInfoListMap.get(searchEngineType);
        if (searchEngineResultsPageRecord == null) {
            return null;
        }
        return new L(searchEngineResultsPageRecord);
    }

    @Nullable
    public static Double getKeywordDifficulty(Keyword keyword, SearchEngineType searchEngineType) {
        SearchEngineResultsPage searchEngineResultsPage = KeywordDifficultyService.getSearchEngineResultsPage(keyword, searchEngineType);
        if (searchEngineResultsPage == null || searchEngineResultsPage.getPageDifficultyDataList().isEmpty()) {
            return null;
        }
        return KeywordDifficultyService.getKeywordDifficulty(searchEngineResultsPage);
    }

    public static double getKeywordDifficulty(SearchEngineResultsPage searchEngineResultsPage) {
        boolean bl = AbstractKeyword.c;
        double d2 = 0.0;
        List<? extends PageDifficultyData> list = searchEngineResultsPage.getPageDifficultyDataList();
        for (PageDifficultyData pageDifficultyData : list) {
            d2 += pageDifficultyData.getDifficultyScore().doubleValue();
            if (!bl) continue;
        }
        return MathUtil.round((double)(d2 / (double)list.size()), (int)1);
    }

    public static void addSearchEngineResultsPage(Keyword keyword, SearchEngineType searchEngineType, PageDifficultyCollection pageDifficultyCollection) {
        SearchEngineResultsPageRecord searchEngineResultsPageRecord;
        PageDifficultyInfoListMap pageDifficultyInfoListMap = keyword.getKeywordDifficultyMap();
        if (pageDifficultyInfoListMap == null) {
            pageDifficultyInfoListMap = new PageDifficultyInfoListMap((Record)keyword);
            keyword.setKeywordDifficultyMap(pageDifficultyInfoListMap);
        }
        if ((searchEngineResultsPageRecord = (SearchEngineResultsPageRecord)pageDifficultyInfoListMap.get(searchEngineType)) == null) {
            searchEngineResultsPageRecord = new SearchEngineResultsPageRecord((Record)pageDifficultyInfoListMap);
            pageDifficultyInfoListMap.put(searchEngineType, searchEngineResultsPageRecord);
        }
        searchEngineResultsPageRecord.a(pageDifficultyCollection);
    }

    @Nullable
    public static IPosition calcLandingPosition(int n2, Keyword keyword, SearchEngineType searchEngineType, boolean bl) {
        boolean bl2 = AbstractKeyword.c;
        IPosition iPosition = new Position(KeywordPosition.getNotFoundPosition(n2), 0, null);
        LandingPage landingPage = keyword.getLandingPage();
        KeywordPosition keywordPosition = keyword.getPosition(searchEngineType);
        if (keywordPosition == null || landingPage == null) {
            return iPosition;
        }
        MultipleKeywordPositionsList multipleKeywordPositionsList = keywordPosition.getMultiplePositions();
        if (multipleKeywordPositionsList == null) {
            return iPosition;
        }
        Iterator iterator = multipleKeywordPositionsList.iterator();
        while (iterator.hasNext()) {
            MultipleKeywordPosition multipleKeywordPosition = (MultipleKeywordPosition)iterator.next();
            if (landingPage.isMatchUrl(multipleKeywordPosition.getUrl(), bl)) {
                iPosition = multipleKeywordPosition;
                break;
            }
            if (!bl2) continue;
        }
        return iPosition;
    }
}

