/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.modules.comparision.data;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.ProjectPanelController;
import com.agilemind.commons.application.controllers.ProjectsTabController;
import com.agilemind.commons.application.data.IProjectLocation;
import com.agilemind.commons.application.data.Project;
import com.agilemind.commons.application.data.TroubleType;
import com.agilemind.commons.application.modules.storage.StorageType;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFileNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.WrongAuthorizationException;
import com.agilemind.commons.application.modules.storage.spscloud.client.exceptions.SpsCloudServerException;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.exceptions.ProjectNotFoundException;
import com.agilemind.commons.application.util.ProjectCorruptException;
import com.agilemind.commons.application.util.ProjectLoaderSaverManager;
import com.agilemind.commons.mvc.api.ProviderFinder;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.spyglass.data.CompareProject;
import com.agilemind.spyglass.data.CompareProjectsList;
import com.agilemind.spyglass.data.ICompareProject;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.StatisticsMode;
import com.agilemind.spyglass.modules.comparision.data.CompareProjectResult;
import com.agilemind.spyglass.modules.comparision.data.CompareResult;
import com.agilemind.spyglass.util.SpyGlassStringKey;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareProjectsManager {
    private static final Logger a;
    private ProviderFinder b;
    private CompareProjectsList c;
    private List<CompareProjectResult<CompareProject>> d;
    private final Map<ICompareProject, SpyGlassProject> e;
    private final List<ICompareProject> f;
    static final boolean g;

    public CompareProjectsManager(ProviderFinder providerFinder, CompareProjectsManager compareProjectsManager) {
        this.d = new ArrayList<CompareProjectResult<CompareProject>>();
        this.e = new HashMap<ICompareProject, SpyGlassProject>();
        this.f = new ArrayList<ICompareProject>();
        this.b = providerFinder;
        this.c = compareProjectsManager.c;
        this.copyFrom(compareProjectsManager);
    }

    public CompareProjectsManager(ProviderFinder providerFinder, CompareProjectsList compareProjectsList) {
        boolean bl = CompareResult.d;
        this.d = new ArrayList<CompareProjectResult<CompareProject>>();
        this.e = new HashMap<ICompareProject, SpyGlassProject>();
        this.f = new ArrayList<ICompareProject>();
        this.b = providerFinder;
        this.c = compareProjectsList;
        this.d = this.a(compareProjectsList);
        if (SpyGlassStringKey.b != 0) {
            boolean bl2 = !bl;
            CompareResult.d = bl2;
        }
    }

    public void fixUnsaved() {
        boolean bl = CompareResult.d;
        for (CompareProjectResult<CompareProject> compareProjectResult : this.d) {
            block5: {
                SpyGlassProject spyGlassProject = this.e.get(compareProjectResult.getCompareProject());
                if (spyGlassProject == null || spyGlassProject.getProjectLocation() == null) break block5;
                compareProjectResult.setUnsaved(false);
            }
            if (!bl) continue;
        }
    }

    private List<CompareProjectResult<CompareProject>> a(CompareProjectsList compareProjectsList) {
        boolean bl = CompareResult.d;
        ArrayList<CompareProjectResult<CompareProject>> arrayList = new ArrayList<CompareProjectResult<CompareProject>>();
        for (CompareProject compareProject : compareProjectsList.getList()) {
            arrayList.add(new CompareProjectResult<CompareProject>(compareProject));
            if (!bl) continue;
        }
        return arrayList;
    }

    public List<CompareProjectResult<CompareProject>> getCompareProjectResults() {
        return this.d;
    }

    public boolean addCompareProject(Color color, SpyGlassProject spyGlassProject, String string, IProjectLocation iProjectLocation) {
        CompareProjectResult<CompareProject> compareProjectResult;
        CompareProject compareProject;
        block6: {
            block5: {
                boolean bl = CompareResult.d;
                compareProject = this.c.createCompareProject();
                compareProject.setProjectColor(color);
                compareProject.setProjectName(string);
                compareProject.setProjectLocation(iProjectLocation);
                compareProjectResult = new CompareProjectResult<CompareProject>(compareProject);
                if (spyGlassProject != null) break block5;
                this.f.add(compareProject);
                compareProjectResult.setNeedCreate(true);
                compareProjectResult.setNeedUpdate(true);
                compareProjectResult.setUnsaved(true);
                if (!bl) break block6;
                int n2 = SpyGlassStringKey.b;
                SpyGlassStringKey.b = ++n2;
            }
            if (iProjectLocation == null) {
                this.e.put(compareProject, spyGlassProject);
                compareProjectResult.setUnsaved(true);
            }
        }
        this.c.add(compareProject);
        return this.d.add(compareProjectResult);
    }

    public void removeCompareProject(CompareProjectResult<CompareProject> compareProjectResult) {
        this.d.remove(compareProjectResult);
        this.c.remove(compareProjectResult.getCompareProject());
        this.e.remove(compareProjectResult.getCompareProject());
        this.f.remove(compareProjectResult.getCompareProject());
    }

    public SpyGlassProject getCheckedUnsaved(CompareProject compareProject) throws InterruptedException {
        return (SpyGlassProject)ThreadSafeUtil.invokeWaitAndReturn(() -> this.a(compareProject));
    }

    public void removeUnsavedProjects() {
        boolean bl = CompareResult.d;
        for (CompareProjectResult<CompareProject> compareProjectResult : this.d) {
            block5: {
                SpyGlassProject spyGlassProject = this.e.get(compareProjectResult.getCompareProject());
                if (spyGlassProject == null || spyGlassProject.getDatabase().getFile() != null) break block5;
                this.c.remove(compareProjectResult.getCompareProject());
            }
            if (!bl) continue;
        }
    }

    public void removeUnsavedProject(SpyGlassProject spyGlassProject) {
        boolean bl = CompareResult.d;
        Iterator<Map.Entry<ICompareProject, SpyGlassProject>> iterator = this.e.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ICompareProject, SpyGlassProject> entry = iterator.next();
            if (entry.getValue() == spyGlassProject) {
                iterator.remove();
            }
            if (!bl) continue;
        }
    }

    public SpyGlassProject getUnsavedProject(ICompareProject iCompareProject) {
        block4: {
            block5: {
                SpyGlassProject spyGlassProject = this.e.get(iCompareProject);
                if (spyGlassProject == null) break block4;
                if (!this.a(spyGlassProject)) break block5;
                return spyGlassProject;
            }
            this.e.remove(iCompareProject);
        }
        return null;
    }

    private boolean a(SpyGlassProject spyGlassProject) {
        return this.c().contains(spyGlassProject);
    }

    private Set<SpyGlassProject> c() {
        boolean bl = CompareResult.d;
        HashSet<SpyGlassProject> hashSet = new HashSet<SpyGlassProject>();
        ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.b.getProvider(ApplicationControllerImpl.class);
        ProjectsTabController projectsTabController = applicationControllerImpl.getProjectsTab();
        List list = projectsTabController.getTabs();
        for (ProjectPanelController projectPanelController : list) {
            hashSet.add((SpyGlassProject)projectPanelController.getProject());
            if (!bl) continue;
        }
        return hashSet;
    }

    public void copyFrom(CompareProjectsManager compareProjectsManager) {
        this.d.clear();
        this.d.addAll(compareProjectsManager.d);
        this.e.clear();
        this.e.putAll(compareProjectsManager.e);
        this.f.clear();
        this.f.addAll(compareProjectsManager.f);
    }

    public SpyGlassProject createProject(CompareProjectResult<CompareProject> compareProjectResult) throws MalformedURLException, InterruptedException {
        return (SpyGlassProject)ThreadSafeUtil.invokeWaitAndReturn(() -> this.a(compareProjectResult));
    }

    public SpyGlassProject loadProject(CompareProjectResult<CompareProject> compareProjectResult) throws IOException, InterruptedException, InvocationTargetException {
        SpyGlassProject spyGlassProject;
        block11: {
            ProjectPanelController projectPanelController;
            block14: {
                IProjectLocation iProjectLocation;
                block13: {
                    block12: {
                        spyGlassProject = this.getCheckedUnsaved(compareProjectResult.getCompareProject());
                        if (spyGlassProject != null) break block11;
                        if (compareProjectResult.getCompareProject() != null) break block12;
                        iProjectLocation = null;
                        break block13;
                    }
                    iProjectLocation = compareProjectResult.getCompareProject().getProjectLocation();
                }
                IProjectLocation iProjectLocation2 = iProjectLocation;
                if (iProjectLocation2 == null) {
                    CompareProjectsManager.a(compareProjectResult, TroubleType.NOT_FOUND);
                    return null;
                }
                CompareProjectsManager.a(compareProjectResult, null);
                compareProjectResult.setUnsaved(false);
                ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.b.getThisProvider(ApplicationControllerImpl.class);
                ProjectsTabController projectsTabController = applicationControllerImpl.getProjectsTab();
                projectPanelController = projectsTabController.getTab(iProjectLocation2);
                if (projectPanelController != null) break block14;
                ProjectLoaderSaverManager projectLoaderSaverManager = applicationControllerImpl.getProjectLoaderSaverManager();
                spyGlassProject = this.a(applicationControllerImpl, compareProjectResult, (ProjectLoaderSaverManager<SpyGlassProject>)projectLoaderSaverManager);
                if (!CompareResult.d) break block11;
            }
            spyGlassProject = (SpyGlassProject)projectPanelController.getProject();
        }
        return spyGlassProject;
    }

    private SpyGlassProject a(ApplicationControllerImpl applicationControllerImpl, CompareProjectResult<CompareProject> compareProjectResult, ProjectLoaderSaverManager<SpyGlassProject> projectLoaderSaverManager) throws InterruptedException, InvocationTargetException {
        try {
            IProjectLocation iProjectLocation;
            block11: {
                iProjectLocation = compareProjectResult.getCompareProject().getProjectLocation();
                if (iProjectLocation.getStorageType() != StorageType.DROPBOX || applicationControllerImpl.getParameters().haveAccount(StorageType.DROPBOX)) break block11;
                CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_WRONG_AUTH);
                return null;
            }
            SpyGlassProject spyGlassProject = this.a(iProjectLocation, projectLoaderSaverManager);
            CompareProjectsManager.a(compareProjectResult, null);
            return spyGlassProject;
        }
        catch (DropboxFileNotFoundException | ProjectNotFoundException | FileNotFoundException throwable) {
            a.error("", throwable);
            CompareProjectsManager.a(compareProjectResult, TroubleType.NOT_FOUND);
        }
        catch (SpsCloudServerException spsCloudServerException) {
            a.error("", (Throwable)spsCloudServerException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.SPS_LOAD_ERROR);
        }
        catch (WrongAuthorizationException wrongAuthorizationException) {
            a.error("", (Throwable)wrongAuthorizationException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_WRONG_AUTH);
        }
        catch (DropboxException dropboxException) {
            a.error("", (Throwable)dropboxException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_LOAD_ERROR);
        }
        catch (ProjectCorruptException projectCorruptException) {
            CompareProjectsManager.a(compareProjectResult, TroubleType.CORRUPTED);
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.CONNECTION_ERROR);
        }
        catch (InterruptedException interruptedException) {
            CompareProjectsManager.a(compareProjectResult, null);
        }
        catch (Throwable throwable) {
            a.error("", throwable);
            CompareProjectsManager.a(compareProjectResult, TroubleType.UNKNOWN);
        }
        return null;
    }

    private SpyGlassProject a(IProjectLocation iProjectLocation, ProjectLoaderSaverManager<SpyGlassProject> projectLoaderSaverManager) throws IOException, InterruptedException {
        return (SpyGlassProject)projectLoaderSaverManager.loadProject(iProjectLocation);
    }

    private static void a(CompareProjectResult<? extends ICompareProject> compareProjectResult, TroubleType troubleType) throws InterruptedException, InvocationTargetException {
        ThreadSafeUtil.invokeAndWait(() -> CompareProjectsManager.b(compareProjectResult, troubleType));
    }

    private static void b(CompareProjectResult compareProjectResult, TroubleType troubleType) {
        compareProjectResult.setTrouble(troubleType);
    }

    private SpyGlassProject a(CompareProjectResult compareProjectResult) throws MalformedURLException {
        CompareProject compareProject;
        SpyGlassProject spyGlassProject;
        block4: {
            spyGlassProject = new SpyGlassProject();
            spyGlassProject.setStatisticsMode(StatisticsMode.BLEX);
            compareProject = (CompareProject)compareProjectResult.getCompareProject();
            if (g || compareProject != null) break block4;
            throw new AssertionError();
        }
        spyGlassProject.setDomain(UnicodeURLUtil.getURLExt((String)compareProject.getProjectName()));
        ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.b.getThisProvider(ApplicationControllerImpl.class);
        ProjectsTabController projectsTabController = applicationControllerImpl.getProjectsTab();
        projectsTabController.createTab((Project)spyGlassProject);
        this.e.put(compareProject, spyGlassProject);
        compareProjectResult.setUnsaved(false);
        compareProjectResult.setNeedCreate(false);
        return spyGlassProject;
    }

    private SpyGlassProject a(CompareProject compareProject) throws RuntimeException {
        SpyGlassProject spyGlassProject;
        block2: {
            spyGlassProject = this.getUnsavedProject(compareProject);
            if (spyGlassProject == null || spyGlassProject.getMetadata() == null) break block2;
            compareProject.setProjectLocation(spyGlassProject.getProjectLocation());
            this.e.remove(compareProject);
            spyGlassProject = null;
        }
        return spyGlassProject;
    }

    static {
        boolean bl = !CompareProjectsManager.class.desiredAssertionStatus();
        g = bl;
        a = LoggerFactory.getLogger(CompareProjectsManager.class);
    }
}

