/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util.statistics.project;

import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TextImageDistribution;
import com.agilemind.commons.util.Util;
import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.util.BacklinkAnalyzeUtil;
import com.agilemind.spyglass.util.SpyGlassStringKey;
import com.agilemind.spyglass.util.statistics.StatisticsService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ProjectStatisticsService
implements StatisticsService {
    private List<AnalyzeRecord> a;
    private int b;
    public static boolean c;

    public ProjectStatisticsService(SpyGlassProject spyGlassProject) {
        this(BacklinkAnalyzeUtil.getAcceptedBacklinks(spyGlassProject), spyGlassProject.getLinkingDomains().getList().size());
    }

    public ProjectStatisticsService(List<AnalyzeRecord> list) {
        this(list, BacklinkAnalyzeUtil.getUniqueDomainsCount(list));
    }

    public ProjectStatisticsService(List<AnalyzeRecord> list, int n2) {
        boolean bl = c;
        this.a = list;
        this.b = n2;
        if (SpyGlassStringKey.b != 0) {
            c = !bl;
        }
    }

    @Override
    public Date getRebuildDate() {
        return new Date();
    }

    @Override
    public int getTotalBacklinksCount() {
        return this.a.size();
    }

    @Override
    public int getTotalLinkingDomainsCount() {
        return this.b;
    }

    @Override
    public int getTotalIpsCount() {
        return BacklinkAnalyzeUtil.getUniqueIPsCount(this.a);
    }

    @Override
    public int getTotalCBlocksCount() {
        return BacklinkAnalyzeUtil.getUniqueCBlocksCount(this.a);
    }

    @Override
    public DofollowNofollowDistribution getDofollowVsNofollowBacklinks() {
        return BacklinkAnalyzeUtil.getDofollowNofollowDistribution(this.a);
    }

    @Override
    public int getTotalDofollowDomainsCount() {
        return BacklinkAnalyzeUtil.getDofollowDomainsCount(this.a);
    }

    @Override
    public HomepageLinksDistribution getFromHomepageVsFromOtherPagesLinkingDomains() {
        return BacklinkAnalyzeUtil.getFromHomepageLinkingDomainsDistribution(this.a);
    }

    @Override
    public TextImageDistribution getTextVsImageBacklinks() {
        return BacklinkAnalyzeUtil.getTextImageDistribution(this.a);
    }

    @Override
    public int getTotalAnchorTexts() {
        return BacklinkAnalyzeUtil.getUniqueAnchorsCount(this.a);
    }

    @Override
    public int getTotalAnchorUrls() {
        return BacklinkAnalyzeUtil.getUniqueAnchorUrlsCount(this.a);
    }

    @Override
    public HomepageLinksDistribution getToHomepageVsToOtherPagesBacklinks() {
        return BacklinkAnalyzeUtil.getToHomepageVsToOtherBacklinksDistribution(this.a);
    }

    @Override
    public List<CountryResult> getTopCountries() {
        List<CountryResult> list = BacklinkAnalyzeUtil.getCountryDistributions(this.a);
        return Util.subList(list, (int)5);
    }

    @Override
    public List<TLDResult> getTopTLDs() {
        List<TLDResult> list = BacklinkAnalyzeUtil.getTLDDistribution(this.a);
        return Util.subList(list, (int)5);
    }

    @Override
    public List<AnchorAltTextResult> getTopBacklinksAnchorTexts(boolean bl) {
        List<AnchorAltTextResult> list = BacklinkAnalyzeUtil.getPagesTopAnchorTexts(this.a, bl);
        return Util.subList(list, (int)50);
    }

    @Override
    public List<AnchorAltTextResult> getTopLinkingDomainsAnchorTexts() {
        List<AnchorAltTextResult> list = BacklinkAnalyzeUtil.getDomainsTopAnchorTexts(this.a);
        return Util.subList(list, (int)50);
    }

    @Override
    public List<AnchorUrlResult> getTopBacklinkAnchorUrls() {
        List<AnchorUrlResult> list = BacklinkAnalyzeUtil.getPagesTopAnchorUrls(this.a);
        return Util.subList(list, (int)50);
    }

    @Override
    public List<AnchorUrlResult> getTopLinkingDomainsAnchorUrls() {
        List<AnchorUrlResult> list = BacklinkAnalyzeUtil.getDomainsTopAnchorUrls(this.a);
        return Util.subList(list, (int)50);
    }

    @Override
    public NavigableMap<Date, Integer> getTotalBacklinksHistory(Date date, Date date2) {
        return ProjectStatisticsService.buildAccrualAndSetLast(BacklinkAnalyzeUtil.getBacklinksIndexByDate(this.a), date2);
    }

    @Override
    public NavigableMap<Date, Integer> getTotalLinkingDomainsHistory(Date date, Date date2) {
        return ProjectStatisticsService.buildAccrualAndSetLast(BacklinkAnalyzeUtil.getDomainsIndexByDate(this.a), date2);
    }

    public static NavigableMap<Date, Integer> buildAccrualAndSetLast(NavigableMap<Date, Integer> navigableMap, Date date) {
        boolean bl = c;
        TreeMap<Date, Integer> treeMap = new TreeMap<Date, Integer>();
        int n2 = 0;
        for (Map.Entry entry : navigableMap.entrySet()) {
            treeMap.put((Date)entry.getKey(), n2 += ((Integer)entry.getValue()).intValue());
            if (!bl) continue;
            int n3 = SpyGlassStringKey.b;
            SpyGlassStringKey.b = ++n3;
            break;
        }
        treeMap.put(date, n2);
        return treeMap;
    }
}

