/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.views.linkrisk;

import com.agilemind.commons.application.data.record.FactorStorage;
import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.io.searchengine.analyzers.util.FilterSiteWithResourcePages;
import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.spyglass.data.LinkRisk;
import com.agilemind.spyglass.data.LinkRiskRule;
import com.agilemind.spyglass.views.linkrisk.LinkRiskCache;
import com.agilemind.spyglass.views.linkrisk.LinkRiskSource;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class LinkRiskUtils {
    public static final ImmutableList<SearchEngineFactorType<? extends Comparable>> LINK_RISK_FACTORS;
    public static boolean b;
    private static final String[] a;

    private LinkRiskUtils() {
    }

    public static LinkRisk getLinkRisk(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache) {
        ScanStatus scanStatus = linkRiskSource.getScanStatus();
        if (scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.LINK_IS_NOFOLLOW));
        }
        if (!scanStatus.isOkStatus()) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.NO_LINK_BACK));
        }
        return LinkRiskUtils.a(linkRiskSource, linkRiskCache, linkRiskCache.getSize());
    }

    private static LinkRisk a(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, int n2) {
        List<SearchEngineFactorType<?>> list = LinkRiskUtils.a(linkRiskSource);
        if (list.isEmpty()) {
            return LinkRiskUtils.b(linkRiskSource, linkRiskCache, n2);
        }
        LinkRisk linkRisk = LinkRisk.createNotCalculatedLinkRisk();
        linkRisk.setSearchEngineTypes(list);
        return linkRisk;
    }

    private static List<SearchEngineFactorType<?>> a(LinkRiskSource linkRiskSource) {
        ArrayList arrayList = new ArrayList();
        ScanStatus scanStatus = linkRiskSource.getScanStatus();
        if (scanStatus == ScanStatus.SCAN_STATUS_UNKNOWN) {
            arrayList.add(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        }
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
        return arrayList;
    }

    private static void a(FactorStorage factorStorage, List<SearchEngineFactorType<?>> list, SearchEngineFactorType<?> searchEngineFactorType) {
        ISearchEngineFactor iSearchEngineFactor = factorStorage.getRankingFactor(searchEngineFactorType);
        if (iSearchEngineFactor == null) {
            list.add(searchEngineFactorType);
        }
    }

    private static LinkRisk b(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, int n2) {
        Integer n3 = (Integer)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE).getFactorValue();
        Integer n4 = (Integer)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE).getFactorValue();
        ArrayList<LinkRiskRule> arrayList = new ArrayList<LinkRiskRule>();
        if (n4 > 1000) {
            arrayList.add(LinkRiskRule.MASSIVE_NUMBER_OF_OUTGOING_LINKS);
        }
        if (LinkRiskUtils.b(linkRiskSource)) {
            arrayList.add(LinkRiskRule.YOUNG_DOMAIN);
        }
        LinkRiskUtils.a(linkRiskSource, linkRiskCache, arrayList);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, linkRiskCache, arrayList);
        ILinkInfo iLinkInfo = linkRiskSource.getLinkInfo();
        if (LinkRiskUtils.a(iLinkInfo)) {
            LinkRiskUtils.a(iLinkInfo, linkRiskCache, arrayList, n2);
        }
        String string = linkRiskSource.getPage().toUnicodeString().toLowerCase();
        LinkRiskUtils.a(string, arrayList);
        LinkRiskUtils.a(string, n3, arrayList);
        return new LinkRisk(arrayList);
    }

    private static boolean b(LinkRiskSource linkRiskSource) {
        if (linkRiskSource == null) {
            throw new IllegalArgumentException(String.format(a[0], a[2], a[1], a[3]));
        }
        Date date = (Date)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).getFactorValue();
        if (!date.equals(IFactorParser.NA_DATE)) {
            Date date2 = new Age(0, 6, 0).getDate();
            return date2.before(date);
        }
        return false;
    }

    private static void a(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, List<LinkRiskRule> list) {
        block5: {
            UnicodeURL unicodeURL = linkRiskSource.getDomain();
            if (unicodeURL != null) {
                String string = UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)unicodeURL);
                Integer n2 = linkRiskCache.getSameDomains(string);
                if (n2 == null || n2 <= 1) break block5;
                list.add(LinkRiskRule.SITE_WIDE_LINK);
            }
        }
    }

    private static void a(FactorStorage factorStorage, LinkRiskCache linkRiskCache, List<LinkRiskRule> list) {
        block10: {
            ISearchEngineFactor iSearchEngineFactor = factorStorage.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (iSearchEngineFactor != null) {
                IP iP;
                block9: {
                    iP = (IP)iSearchEngineFactor.getFactorValue();
                    Set<String> set = linkRiskCache.getSameIPs(iP);
                    if (set == null || set.size() <= 1) break block9;
                    list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP);
                }
                String string = LinkRiskUtils.a(iP);
                Set<String> set = linkRiskCache.getSameClassC(string);
                if (set == null || set.size() <= 1) break block10;
                list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP_C_CLASS);
            }
        }
    }

    private static void a(ILinkInfo iLinkInfo, LinkRiskCache linkRiskCache, List<LinkRiskRule> list, int n2) {
        String string;
        boolean bl;
        block11: {
            bl = b;
            string = iLinkInfo.getName().toLowerCase().trim();
            Integer n3 = linkRiskCache.getSameAnchorText(string);
            if (n3 == null || !((double)n3.intValue() > (double)n2 * 0.05)) break block11;
            list.add(LinkRiskRule.MANY_SAME_ANCHORS);
        }
        Set set = StringUtil.getUniqueKeywords((String)string);
        for (String string2 : set) {
            block12: {
                Integer n4 = linkRiskCache.getSameAnchorKeywords(string2);
                if (n4 == null || !((double)n4.intValue() > (double)n2 * 0.1)) break block12;
                list.add(LinkRiskRule.MANY_SAME_KEYWORD_IN_ANCHOR);
                if (!bl) break;
            }
            if (!bl) continue;
            break;
        }
    }

    static String a(IP iP) {
        int[] nArray = iP.getDigits();
        return String.valueOf(nArray[0]) + nArray[1] + nArray[2];
    }

    static boolean a(ILinkInfo iLinkInfo) {
        boolean bl;
        block9: {
            block8: {
                if (iLinkInfo == null || !iLinkInfo.isTextLink()) break block8;
                if (iLinkInfo.getBanner() != null) break block8;
                if (StringUtil.isEmpty((String)iLinkInfo.getName())) break block8;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    private static void a(String string, List<LinkRiskRule> list) {
        boolean bl = b;
        for (String string2 : FilterSiteWithResourcePages.PAGE_NAMES) {
            if (!StringUtil.containsIgnoreCase((String)string, (String)string2)) continue;
            list.add(LinkRiskRule.LINK_DIRECTORY_LINK);
            return;
        }
    }

    private static void a(String string, Integer n2, List<LinkRiskRule> list) {
        block4: {
            if (n2 < 60 || !StringUtil.containsIgnoreCase((String)string, (String)a[4])) break block4;
            list.add(LinkRiskRule.POTENTIAL_SPAM_FORUM);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "U[\u0019m0qG\n8;{[^X\u0013{]0m1x\t\u000ey/uD\u001bl8f\tY=.3\t\u0011~}1ZP=.4D\u000bk)4G\u0011l}vL^v(xE";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 20;
                                break;
                            }
                            case 1: {
                                n9 = 41;
                                break;
                            }
                            case 2: {
                                n9 = 126;
                                break;
                            }
                            case 3: {
                                n9 = 24;
                                break;
                            }
                            default: {
                                n9 = 93;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "wF\u00137<s@\u0012}0}G\u001a7.dP\u0019t<gZQn4q^\r71}G\u0015j4gBQT4zB,q.\u007f|\nq1g";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "x@\u0010s\u000f}Z\u0015K2a[\u001d}";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "}Z'w(zN:w0u@\u0010";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "rF\fm0";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
        LINK_RISK_FACTORS = ImmutableList.builder().add((Object)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE).add((Object)SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE).add((Object)SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE).add((Object)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).add((Object)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE).build();
    }
}

