/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.auditcommon.crawler;

import com.agilemind.auditcommon.crawler.CrawlerContext;
import com.agilemind.auditcommon.crawler.ISiteCrawlingSettings;
import com.agilemind.auditcommon.crawler.ObjectPool;
import com.agilemind.auditcommon.crawler.ResourceSourceType;
import com.agilemind.auditcommon.crawler.ResourceType;
import com.agilemind.auditcommon.crawler.fetcher.PageFetcher;
import com.agilemind.auditcommon.crawler.fetcher.PageFetcherImpl;
import com.agilemind.auditcommon.crawler.parser.PageParser;
import com.agilemind.auditcommon.crawler.parser.PageParserImpl;
import com.agilemind.auditcommon.crawler.robots.CrawlerBotChecker;
import com.agilemind.auditcommon.crawler.robots.CrawlerRobotsStorage;
import com.agilemind.auditcommon.crawler.to.CrawlerPage;
import com.agilemind.auditcommon.crawler.to.CrawlerResource;
import com.agilemind.auditcommon.crawler.to.UrlData;
import com.agilemind.auditcommon.crawler.to.UrlID;
import com.agilemind.auditcommon.crawler.util.CrawlingUtil;
import com.agilemind.commons.io.searchengine.robots.data.RobotsValue;
import com.agilemind.commons.util.Pair;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;

public class CrawlingStorage
implements CrawlerBotChecker {
    private final boolean a;
    private int b;
    private int c;
    private final Set<UrlID> d;
    @Nullable
    private final Set<UrlID> e;
    @Nullable
    private final Set<UrlID> f;
    private final Set<CrawlerPage> g;
    private final Set<CrawlerResource> h;
    private final Lock i;
    private final Lock j;
    private final Map<UrlID, UrlID> k;
    private final Map<UrlID, Integer> l;
    private final AtomicInteger m;
    private final AtomicInteger n;
    private final AtomicInteger o;
    private final ObjectPool<PageFetcher> p;
    private final ObjectPool<PageParser> q;
    private final CrawlerRobotsStorage r;
    private final Set<ResourceType> s;
    static final boolean t = !CrawlingStorage.class.desiredAssertionStatus();

    public CrawlingStorage(CrawlerContext crawlerContext) {
        this(crawlerContext, PageFetcherImpl::new, PageParserImpl::new);
    }

    public CrawlingStorage(CrawlerContext crawlerContext, Supplier<PageFetcher> supplier, Supplier<PageParser> supplier2) {
        int n2 = ResourceSourceType.c;
        this.i = new ReentrantLock(true);
        this.j = new ReentrantLock(true);
        this.d = Sets.newConcurrentHashSet();
        this.g = Sets.newConcurrentHashSet();
        this.h = Sets.newConcurrentHashSet();
        ISiteCrawlingSettings iSiteCrawlingSettings = crawlerContext.getCrawlingSettings();
        this.a = iSiteCrawlingSettings.isUseDepthLimit();
        this.e = this.a ? Sets.newConcurrentHashSet() : null;
        this.f = this.a ? Sets.newConcurrentHashSet() : null;
        this.k = new HashMap<UrlID, UrlID>();
        this.l = new HashMap<UrlID, Integer>();
        this.b = iSiteCrawlingSettings.getRedirectDepthLimit();
        this.c = iSiteCrawlingSettings.getClickDepthLimit();
        this.m = new AtomicInteger(0);
        this.n = new AtomicInteger(0);
        this.o = new AtomicInteger(0);
        this.p = new ObjectPool<PageFetcher>(supplier == null ? PageFetcherImpl::new : supplier);
        this.q = new ObjectPool<PageParser>(supplier2 == null ? PageParserImpl::new : supplier2);
        this.r = new CrawlerRobotsStorage(crawlerContext.getProjectUrl().getIDNHost(), iSiteCrawlingSettings);
        this.s = ImmutableSet.copyOf(iSiteCrawlingSettings.getWebResources());
        if (n2 != 0) {
            int n3 = WebsiteAuditorStringKey.b;
            WebsiteAuditorStringKey.b = ++n3;
        }
    }

    public ObjectPool<PageFetcher> getFetcherPool() {
        return this.p;
    }

    public ObjectPool<PageParser> getParserPool() {
        return this.q;
    }

    public Set<UrlID> getUrlCrawled() {
        return this.d;
    }

    public void setClickLimit(int n2) {
        this.c = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCrawlIfNeeded(UrlData urlData) {
        UrlID urlID = urlData.getUrlID();
        boolean bl = this.d.add(urlID);
        if (bl) {
            this.m.incrementAndGet();
        }
        if (this.a) {
            this.j.lock();
            try {
                if (!(t || this.f != null && this.e != null)) {
                    throw new AssertionError();
                }
                if (urlData.getClickDepth() == this.c + 1) {
                    boolean bl2 = this.e.add(urlID);
                    if (bl2 && bl && this.a(urlID.getUrl())) {
                        this.f.add(urlID);
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                if (urlData.getClickDepth() < this.c + 1) {
                    boolean bl4 = (this.f.remove(urlID) || bl) && this.a(urlID.getUrl());
                    return bl4;
                }
            }
            finally {
                this.j.unlock();
            }
        }
        return bl && this.a(urlID.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEachClickLeafPagesIf(Predicate<? super UrlID> predicate) {
        if (this.a) {
            this.j.lock();
            try {
                if (!t && this.f == null) {
                    throw new AssertionError();
                }
                Set<UrlID> set = this.f;
                synchronized (set) {
                    this.f.removeIf(predicate);
                }
            }
            finally {
                this.j.unlock();
            }
        }
    }

    public void putPage(CrawlerPage crawlerPage) {
        if (!t && this.g.contains(crawlerPage)) {
            throw new AssertionError();
        }
        this.g.add(crawlerPage);
        this.n.incrementAndGet();
        this.o.incrementAndGet();
    }

    public void putResource(CrawlerResource crawlerResource) {
        if (!t && this.h.contains(crawlerResource)) {
            throw new AssertionError();
        }
        this.h.add(crawlerResource);
        this.n.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<UrlID, Integer> getRedirectedIfNeeded(UrlID urlID, UrlID urlID2, int n2) {
        int n3;
        UrlID urlID3;
        block12: {
            int n4 = ResourceSourceType.c;
            urlID3 = null;
            n3 = n2;
            this.i.lock();
            try {
                Integer n5;
                if (this.k.get(urlID) != null) {
                    if (!t && !this.k.get(urlID).equals(urlID2)) {
                        throw new AssertionError();
                    }
                } else {
                    this.k.put(urlID, urlID2);
                }
                if (n3 > this.b) {
                    urlID3 = null;
                    if (n4 == 0) break block12;
                }
                if ((n5 = this.l.get(urlID2)) == null) {
                    this.l.put(urlID2, n2);
                    urlID3 = urlID2;
                } else if (n5 > n2) {
                    UrlID urlID4 = urlID2;
                    UrlID urlID5 = null;
                    do {
                        if ((urlID4 = this.k.get(urlID4)) == null) continue;
                        this.l.put(urlID4, ++n3);
                        urlID5 = urlID4;
                    } while (n3 < this.b && urlID4 != null);
                    urlID3 = urlID5;
                }
            }
            finally {
                this.i.unlock();
            }
        }
        return urlID3 != null ? Pair.create(urlID3, (Object)n3) : null;
    }

    public Set<CrawlerResource> getResourceResult() {
        return this.h;
    }

    public Set<CrawlerPage> getPagesResult() {
        return this.g;
    }

    public int getTotalResourceCount() {
        return this.m.intValue();
    }

    public int getFinishResourceCount() {
        return this.n.intValue();
    }

    public int getFinishPagesCount() {
        return this.o.intValue();
    }

    public synchronized void updateRobots(String string, String string2) {
        this.r.setRobotsContent(string, string2);
    }

    public String getRobotsContent(UnicodeURL unicodeURL) {
        return this.r.getRobotsContent(unicodeURL);
    }

    @Override
    public RobotsValue allowRobotsTxt(UnicodeURL unicodeURL) {
        return this.r.allowRobotsTxt(unicodeURL);
    }

    @Override
    public Pair<RobotsValue, Boolean> allowXRobotsTag(Iterable<String> iterable) {
        return this.r.allowXRobotsTag(iterable);
    }

    @Override
    public RobotsValue allowMetaRobots(Document document) {
        return this.r.allowMetaRobots(document);
    }

    public CrawlerRobotsStorage getRobotsManager() {
        return this.r;
    }

    private boolean a(UnicodeURL unicodeURL) {
        ResourceType resourceType = CrawlingUtil.convertExtension(unicodeURL);
        return resourceType == ResourceType.HTML || this.s.contains((Object)resourceType);
    }
}

