/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit;

import com.agilemind.auditcommon.crawler.ResourceSourceType;
import com.agilemind.auditcommon.crawler.ResourceType;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.analyzers.data.PageInfo;
import com.agilemind.commons.io.searchengine.analyzers.data.PageInfoKeys;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.localization.util.LocalizedStringUtil;
import com.agilemind.commons.util.StatusCodeConstants;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.agilemind.sitescan.data.HttpResponseCode;
import com.agilemind.sitescan.data.HttpResponseCodeGroup;
import com.agilemind.sitescan.data.audit.DomainAuditResultView;
import com.agilemind.sitescan.data.audit.PagesAuditResultView;
import com.agilemind.sitescan.data.audit.SiteAuditFactorCategory;
import com.agilemind.sitescan.data.audit.SiteAuditFactorType;
import com.agilemind.sitescan.data.audit.SiteAuditResultView;
import com.agilemind.sitescan.data.audit.factor.DomainAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.PagesAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.ResourcesAuditFactorType;
import com.agilemind.sitescan.data.audit.factor.ResourcesAuditResultView;
import com.agilemind.sitescan.data.audit.factor.SiteAuditResultType;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditFactor;
import com.agilemind.sitescan.data.audit.factor.domain.DomainAuditResult;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditResult;
import com.agilemind.sitescan.data.audit.factor.resources.ResourcesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.resources.ResourcesAuditResult;
import com.agilemind.websiteauditor.data.PageContainer;
import com.agilemind.websiteauditor.data.Resource;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import com.agilemind.websiteauditor.data.resourcesource.ImageResourceSource;
import com.agilemind.websiteauditor.data.resourcesource.ResourceSource;
import com.agilemind.websiteauditor.util.WebsiteAuditorStringKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class SiteAuditUtil {
    private static final String[] a;

    public static <T extends Resource> List<T> getResourcesWithoutRedirect(List<T> list) {
        return list.stream().filter(SiteAuditUtil::a).collect(Collectors.toList());
    }

    public static <T extends Resource> List<T> getResourcesWithHttpResponseCode(List<T> list, HttpResponseCodeGroup httpResponseCodeGroup) {
        return list.stream().filter(arg_0 -> SiteAuditUtil.a(httpResponseCodeGroup, arg_0)).collect(Collectors.toList());
    }

    public static <T extends Resource> List<T> getResourcesWithHttpResponseCode(List<T> list, HttpResponseCode httpResponseCode) {
        return list.stream().filter(arg_0 -> SiteAuditUtil.a(httpResponseCode, arg_0)).collect(Collectors.toList());
    }

    public static Map<String, List<WebsiteAuditorPage>> getPagesWithDuplicateTitle(List<WebsiteAuditorPage> list) {
        return SiteAuditUtil.getPagesWithDuplicateTag(list, PageInfoKeys.title);
    }

    public static Map<String, List<WebsiteAuditorPage>> getPagesWithDuplicateMetaDescription(List<WebsiteAuditorPage> list) {
        return SiteAuditUtil.getPagesWithDuplicateTag(list, PageInfoKeys.description);
    }

    public static Map<String, List<WebsiteAuditorPage>> getPagesWithDuplicateTag(List<WebsiteAuditorPage> list, PageInfoKeys pageInfoKeys) {
        int n2 = SiteAuditResultView.d;
        TreeMap<String, List<WebsiteAuditorPage>> treeMap = new TreeMap<String, List<WebsiteAuditorPage>>(SiteAuditUtil::a);
        for (WebsiteAuditorPage object : list) {
            if (SiteAuditUtil.a(object) && n2 == 0) continue;
            if (!SiteAuditUtil.b(object) && n2 == 0) continue;
            if (SiteAuditUtil.a(pageInfoKeys, object) && n2 == 0) continue;
            SearchEngineFactor searchEngineFactor = object.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
            String string = (String)((PageInfo)searchEngineFactor.getFactorValue()).get((Object)pageInfoKeys);
            if (PageInfo.NOT_FOUND.equals(string) && n2 == 0) continue;
            ArrayList<WebsiteAuditorPage> arrayList = (ArrayList<WebsiteAuditorPage>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<WebsiteAuditorPage>();
                treeMap.put(string, arrayList);
            }
            if (!SiteAuditUtil.a(arrayList, object)) {
                arrayList.add(object);
            }
            if (n2 == 0) continue;
        }
        Iterator<Object> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((List)entry.getValue()).size() < 2) {
                iterator.remove();
            }
            if (n2 == 0) continue;
        }
        TreeMap<String, List<WebsiteAuditorPage>> treeMap2 = treeMap;
        if (WebsiteAuditorStringKey.b != 0) {
            SiteAuditResultView.d = ++n2;
        }
        return treeMap2;
    }

    public static List<WebsiteAuditorPage> getPagesWithMissingEmptyTitleTag(List<WebsiteAuditorPage> list) {
        return SiteAuditUtil.getPagesWithMissingEmptyTag(list, PageInfoKeys.title);
    }

    public static List<WebsiteAuditorPage> getPagesWithMissingEmptyMetaDescriptionTag(List<WebsiteAuditorPage> list) {
        return SiteAuditUtil.getPagesWithMissingEmptyTag(list, PageInfoKeys.description);
    }

    public static List<WebsiteAuditorPage> getPagesWithMissingEmptyTag(List<WebsiteAuditorPage> list, PageInfoKeys pageInfoKeys) {
        int n2 = SiteAuditResultView.d;
        ArrayList<WebsiteAuditorPage> arrayList = new ArrayList<WebsiteAuditorPage>();
        for (WebsiteAuditorPage websiteAuditorPage : list) {
            block10: {
                SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
                if (searchEngineFactor != null) {
                    block11: {
                        PageInfo pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
                        if (pageInfo == null || pageInfo.isNa().booleanValue()) break block10;
                        String string = (String)pageInfo.get((Object)pageInfoKeys);
                        if (string == null) break block10;
                        if (string.trim().length() == 0) break block11;
                        if (!PageInfo.NOT_FOUND.equals(string)) break block10;
                    }
                    arrayList.add(websiteAuditorPage);
                }
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static boolean isBrokenLink(PageContainer pageContainer) {
        Object t2 = pageContainer.getResourceSource();
        ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
        if (!resourceSourceType.isLinkType()) {
            return false;
        }
        if (pageContainer.getUrl() == null) {
            boolean bl;
            block17: {
                block16: {
                    String string = ((ResourceSource)pageContainer.getResourceSource()).getLink();
                    if (StringUtil.isEmpty((String)string) || StatusCodeConstants.isUnsupportedProtocol((String)string)) break block16;
                    if (StatusCodeConstants.isBinaryData((String)string)) break block16;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
            return bl;
        }
        Resource resource = pageContainer.getResource();
        if (resource == null) {
            return false;
        }
        Integer n2 = resource.getHttpStatusCode();
        if (n2 == null) {
            return false;
        }
        return SiteAuditUtil.isBrokenStatusCode(n2);
    }

    public static boolean isBrokenImage(PageContainer pageContainer) {
        Integer n2;
        Resource resource;
        block20: {
            Object t2 = pageContainer.getResourceSource();
            ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
            if (resourceSourceType != ResourceSourceType.IMG_TAG) {
                return false;
            }
            if (pageContainer.getUrl() == null) {
                boolean bl;
                block19: {
                    block18: {
                        block17: {
                            String string = ((ResourceSource)pageContainer.getResourceSource()).getLink();
                            if (StringUtil.isEmpty((String)string)) break block17;
                            if (StatusCodeConstants.isUnsupportedProtocol((String)string)) break block18;
                            if (StatusCodeConstants.isBinaryData((String)string)) break block18;
                        }
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
                return bl;
            }
            resource = pageContainer.getResource();
            if (resource == null) {
                return false;
            }
            n2 = resource.getHttpStatusCode();
            if (n2 == null || !SiteAuditUtil.isBrokenStatusCode(n2)) break block20;
            return true;
        }
        String string = resource.getContentType();
        return SiteAuditUtil.isBrokenImageContentType(string, n2);
    }

    public static boolean isBrokenImageContentType(String string, @Nullable Integer n2) {
        boolean bl;
        block11: {
            block10: {
                if (IFactorParser.NA_DATA.equals(string) || n2 == null) break block10;
                if (HttpResponseCodeGroup.RES_3XX.accept(n2)) break block10;
                if (a[0].equalsIgnoreCase(string)) break block10;
                if (ResourceType.convertContentType(string) == ResourceType.IMAGES) break block10;
                bl = true;
                break block11;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isBrokenStatusCode(int n2) {
        boolean bl;
        block12: {
            block11: {
                block10: {
                    if (n2 == -1 || n2 == -3) break block10;
                    if (n2 == -4) break block10;
                    if (HttpResponseCodeGroup.RES_4XX.accept(n2)) break block10;
                    if (!HttpResponseCodeGroup.RES_5XX.accept(n2)) break block11;
                }
                bl = true;
                break block12;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isEmptyAltText(PageContainer pageContainer) {
        Object t2 = pageContainer.getResourceSource();
        ResourceSourceType resourceSourceType = ((ResourceSource)t2).getResourceSourceType();
        if (resourceSourceType != ResourceSourceType.IMG_TAG) {
            return false;
        }
        return StringUtil.isEmpty((String)((ImageResourceSource)pageContainer.getResourceSource()).getAltText());
    }

    private static boolean a(WebsiteAuditorPage websiteAuditorPage) {
        SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.HTTP_RESPONSE_CODE_FACTOR_TYPE);
        if (searchEngineFactor == null) {
            return true;
        }
        Integer n2 = (Integer)searchEngineFactor.getFactorValue();
        boolean bl = n2 != 200;
        return bl;
    }

    private static boolean b(WebsiteAuditorPage websiteAuditorPage) {
        SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        if (searchEngineFactor != null) {
            PageInfo pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
            UnicodeURL unicodeURL = pageInfo.getCanonicalUrl();
            if (unicodeURL == null) {
                return true;
            }
            UnicodeURL unicodeURL2 = websiteAuditorPage.getPageUrl();
            return unicodeURL2.equals((Object)unicodeURL);
        }
        return true;
    }

    private static boolean a(PageInfoKeys pageInfoKeys, WebsiteAuditorPage websiteAuditorPage) {
        boolean bl;
        block13: {
            block12: {
                PageInfo pageInfo;
                block11: {
                    SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
                    if (searchEngineFactor == null) {
                        return true;
                    }
                    pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
                    if (pageInfo != null && !pageInfo.isRedirect()) break block11;
                    return true;
                }
                String string = (String)pageInfo.get((Object)pageInfoKeys);
                if (!StringUtil.isEmpty((String)string) && !LocalizedStringUtil.NA_STRING.getString().equals(string)) break block12;
                bl = true;
                break block13;
            }
            bl = false;
        }
        return bl;
    }

    private static boolean a(List<WebsiteAuditorPage> list, WebsiteAuditorPage websiteAuditorPage) {
        return Util.contains(list, (Object)((Object)websiteAuditorPage), SiteAuditUtil::a);
    }

    public static Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> createSiteAuditFactorsModel(List<WebsiteAuditorPage> list, List<Resource> list2, List<SearchEngineFactorType<? extends Comparable>> list3, PopularityHistoryMap popularityHistoryMap) {
        int n2 = SiteAuditResultView.d;
        Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> map = Collections.synchronizedMap(new EnumMap(SiteAuditFactorCategory.class));
        ((Stream)Arrays.stream(SiteAuditFactorType.values()).filter(SiteAuditFactorType::isSupported).filter(arg_0 -> SiteAuditUtil.a(list3, arg_0)).parallel()).forEach(arg_0 -> SiteAuditUtil.a(map, popularityHistoryMap, list, list2, arg_0));
        if (n2 != 0) {
            int n3 = WebsiteAuditorStringKey.b;
            WebsiteAuditorStringKey.b = ++n3;
        }
        return map;
    }

    private static void a(Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> map, ResourcesAuditFactorType resourcesAuditFactorType, SiteAuditFactorType siteAuditFactorType, SiteAuditFactorCategory siteAuditFactorCategory, List<Resource> list) {
        ResourcesAuditFactor resourcesAuditFactor = resourcesAuditFactorType.createAuditFactor();
        ResourcesAuditResult resourcesAuditResult = resourcesAuditFactor.getSiteAuditResult(list);
        SiteAuditUtil.a(map, siteAuditFactorCategory, new ResourcesAuditResultView(siteAuditFactorType, resourcesAuditResult));
    }

    private static void a(Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> map, PagesAuditFactorType pagesAuditFactorType, SiteAuditFactorType siteAuditFactorType, SiteAuditFactorCategory siteAuditFactorCategory, List<WebsiteAuditorPage> list) {
        PagesAuditFactor pagesAuditFactor = pagesAuditFactorType.createAuditFactor();
        PagesAuditResult pagesAuditResult = pagesAuditFactor.getSiteAuditResult(list);
        SiteAuditUtil.a(map, siteAuditFactorCategory, new PagesAuditResultView(siteAuditFactorType, pagesAuditResult));
    }

    private static void a(Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> map, DomainAuditFactorType domainAuditFactorType, SiteAuditFactorType siteAuditFactorType, SiteAuditFactorCategory siteAuditFactorCategory, PopularityHistoryMap popularityHistoryMap) {
        DomainAuditFactor domainAuditFactor = domainAuditFactorType.createAuditFactor();
        DomainAuditResult domainAuditResult = domainAuditFactor.getDomainAuditResult((IPopularityMap)popularityHistoryMap);
        SiteAuditUtil.a(map, siteAuditFactorCategory, new DomainAuditResultView(siteAuditFactorType, domainAuditResult));
    }

    private static void a(Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>> map, SiteAuditFactorCategory siteAuditFactorCategory, SiteAuditResultView siteAuditResultView) {
        Comparator comparator = SiteAuditUtil::a;
        map.computeIfAbsent(siteAuditFactorCategory, arg_0 -> SiteAuditUtil.a(comparator, arg_0)).add(siteAuditResultView);
    }

    private static Collection a(Comparator comparator, SiteAuditFactorCategory siteAuditFactorCategory) {
        return Collections.synchronizedSet(new TreeSet(comparator));
    }

    private static int a(SiteAuditResultView siteAuditResultView, SiteAuditResultView siteAuditResultView2) {
        return siteAuditResultView.getSiteAuditFactorType().compareTo(siteAuditResultView2.getSiteAuditFactorType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(Map map, PopularityHistoryMap popularityHistoryMap, List list, List list2, SiteAuditFactorType siteAuditFactorType) {
        int n2 = SiteAuditResultView.d;
        com.agilemind.sitescan.data.audit.factor.SiteAuditFactorType siteAuditFactorType2 = siteAuditFactorType.getSiteAuditFactorType();
        SiteAuditFactorCategory siteAuditFactorCategory = siteAuditFactorType.getSiteAuditFactorCategory();
        SiteAuditResultType siteAuditResultType = siteAuditFactorType2.getResultType();
        switch (siteAuditResultType) {
            case DOMAIN: {
                SiteAuditUtil.a((Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>>)map, (DomainAuditFactorType)siteAuditFactorType2, siteAuditFactorType, siteAuditFactorCategory, popularityHistoryMap);
                if (n2 == 0) break;
            }
            case PAGES: {
                SiteAuditUtil.a((Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>>)map, (PagesAuditFactorType)siteAuditFactorType2, siteAuditFactorType, siteAuditFactorCategory, list);
                if (n2 == 0) break;
            }
            case RESOURCES: {
                SiteAuditUtil.a((Map<SiteAuditFactorCategory, Collection<SiteAuditResultView>>)map, (ResourcesAuditFactorType)siteAuditFactorType2, siteAuditFactorType, siteAuditFactorCategory, list2);
                if (n2 == 0) break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)siteAuditResultType) + a[1]);
            }
        }
    }

    private static boolean a(List list, SiteAuditFactorType siteAuditFactorType) {
        boolean bl;
        block5: {
            block4: {
                if (siteAuditFactorType.getDependSearchEngineFactorType() != null && !list.contains(siteAuditFactorType.getDependSearchEngineFactorType())) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private static int a(WebsiteAuditorPage websiteAuditorPage, WebsiteAuditorPage websiteAuditorPage2) {
        String string = UnicodeURLUtil.removeTrailingSlash((String)UnicodeURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)websiteAuditorPage.getPageUrl())));
        String string2 = UnicodeURLUtil.removeTrailingSlash((String)UnicodeURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)websiteAuditorPage2.getPageUrl())));
        return string.compareTo(string2);
    }

    private static int a(String string, String string2) {
        return Util.compare((Object)StringUtil.toLowerCase((String)StringUtil.trim((String)string)), (Object)StringUtil.toLowerCase((String)StringUtil.trim((String)string2)));
    }

    private static boolean a(HttpResponseCode httpResponseCode, Resource resource) {
        SearchEngineFactor searchEngineFactor = resource.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.HTTP_RESPONSE_CODE_FACTOR_TYPE);
        if (searchEngineFactor == null) {
            return false;
        }
        Integer n2 = (Integer)searchEngineFactor.getFactorValue();
        boolean bl = httpResponseCode.getCode() == n2.intValue();
        return bl;
    }

    private static boolean a(HttpResponseCodeGroup httpResponseCodeGroup, Resource resource) {
        SearchEngineFactor searchEngineFactor = resource.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.HTTP_RESPONSE_CODE_FACTOR_TYPE);
        if (searchEngineFactor == null) {
            return false;
        }
        Integer n2 = (Integer)searchEngineFactor.getFactorValue();
        return httpResponseCodeGroup.accept(n2);
    }

    private static boolean a(Resource resource) {
        boolean bl;
        block8: {
            block7: {
                SearchEngineFactor searchEngineFactor = resource.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.HTTP_RESPONSE_CODE_FACTOR_TYPE);
                if (searchEngineFactor == null) {
                    return true;
                }
                Integer n2 = (Integer)searchEngineFactor.getFactorValue();
                if (n2 != null && HttpResponseCodeGroup.RES_3XX.accept(n2)) break block7;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0011=-\u000ev\u0013,)\u000bp\u001eb2\u0001k\u00159p\u0011k\u0002(<\u000f";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 112;
                                break;
                            }
                            case 1: {
                                n9 = 77;
                                break;
                            }
                            case 2: {
                                n9 = 93;
                                break;
                            }
                            case 3: {
                                n9 = 98;
                                break;
                            }
                            default: {
                                n9 = 31;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "P#2\u0016?\u0019 -\u000ez\u001d(3\u0016z\u0014";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

