/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.pages;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.PageInfo;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.sitescan.data.audit.factor.pages.FactorDependPagesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditResult;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import java.util.List;
import java.util.stream.Collectors;

public class PagesWithTooLongMetaDescriptionAuditFactor
extends FactorDependPagesAuditFactor {
    public static final int MAX_NORMAL_META_DESCRIPTION_LENGTH = 155;

    public PagesWithTooLongMetaDescriptionAuditFactor() {
        super(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
    }

    @Override
    public PagesAuditResult getResult(List<WebsiteAuditorPage> list) {
        List<WebsiteAuditorPage> list2 = list.stream().filter(PagesWithTooLongMetaDescriptionAuditFactor::a).collect(Collectors.toList());
        return new PagesAuditResult(list2.size() == 0 ? AuditStatusType.OK : AuditStatusType.WARNING, list2);
    }

    private static boolean a(WebsiteAuditorPage websiteAuditorPage) {
        SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        if (searchEngineFactor == null) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)searchEngineFactor.getFactorValue();
        if (pageInfo == null) {
            return false;
        }
        String string = pageInfo.getDescription();
        return !StringUtil.isEmpty((String)string) && string.length() > 155;
    }
}

