/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.audit.page.technical;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.YesNoPageAuditResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.BooleanResult;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.websiteauditor.audit.page.technical.PageRestrictedFromIndexingAuditFactor;
import com.agilemind.websiteauditor.audit.page.technical.common.PageTechnicalAuditFactor;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;

public class MobileFriendlyPageAuditFactor
implements PageTechnicalAuditFactor {
    @Override
    public PageAuditResult getResult(WebsiteAuditorPage websiteAuditorPage) {
        int n2 = PageRestrictedFromIndexingAuditFactor.b;
        PopularityMap popularityMap = websiteAuditorPage.getPopularityMap();
        ISearchEngineFactor iSearchEngineFactor = popularityMap.getFactor((FactorType)SearchEngineFactorsList.MOBILE_FRIENDLY);
        AuditStatusType auditStatusType = AuditStatusType.NOT_YET_CHECKED;
        if (iSearchEngineFactor != null) {
            BooleanResult booleanResult = (BooleanResult)iSearchEngineFactor.getFactorValue();
            switch (booleanResult) {
                case TRUE: {
                    auditStatusType = AuditStatusType.OK;
                    if (n2 == 0) break;
                }
                case FALSE: {
                    auditStatusType = AuditStatusType.WARNING;
                    if (n2 == 0) break;
                }
                case NA: {
                    auditStatusType = AuditStatusType.N_A;
                }
            }
        }
        return new YesNoPageAuditResult(auditStatusType, AuditStatusType.WARNING, AuditStatusType.OK);
    }
}

