/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.audit.page.technical;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.robots.data.RobotsResult;
import com.agilemind.commons.io.searchengine.robots.data.RobotsValue;
import com.agilemind.websiteauditor.audit.page.technical.common.PageTechnicalAuditFactor;
import com.agilemind.websiteauditor.audit.page.technical.result.ResourceRestrictedAuditResult;
import com.agilemind.websiteauditor.audit.page.technical.result.RestrictedMethodType;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import java.util.ArrayList;

public class PageRestrictedFromIndexingAuditFactor
implements PageTechnicalAuditFactor {
    public static int b;

    @Override
    public PageAuditResult getResult(WebsiteAuditorPage websiteAuditorPage) {
        int n2 = b;
        RestrictedMethodType[] restrictedMethodTypeArray = null;
        AuditStatusType auditStatusType = AuditStatusType.NOT_YET_CHECKED;
        SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
        if (searchEngineFactor != null) {
            RobotsResult robotsResult = (RobotsResult)searchEngineFactor.getFactorValue();
            switch (robotsResult.getStatus()) {
                case ALLOW: {
                    auditStatusType = AuditStatusType.OK;
                    if (n2 == 0) break;
                }
                case PARTIALLY_DISALLOW: {
                    auditStatusType = AuditStatusType.INFO;
                    if (n2 == 0) break;
                }
                case DISALLOW: {
                    auditStatusType = AuditStatusType.ERROR;
                }
            }
            if (auditStatusType == AuditStatusType.INFO || auditStatusType == AuditStatusType.ERROR) {
                ArrayList<RestrictedMethodType> arrayList = new ArrayList<RestrictedMethodType>();
                if (robotsResult.getRobotsResult() == RobotsValue.PARTIALLY_DISALLOW || robotsResult.getRobotsResult() == RobotsValue.DISALLOW) {
                    arrayList.add(RestrictedMethodType.ROBOTS_TXT);
                }
                if (robotsResult.getXRobotsResult() == RobotsValue.PARTIALLY_DISALLOW || robotsResult.getXRobotsResult() == RobotsValue.DISALLOW) {
                    arrayList.add(RestrictedMethodType.X_ROBOTS_TAG);
                }
                if (robotsResult.getNoIndexResult() == RobotsValue.PARTIALLY_DISALLOW || robotsResult.getNoIndexResult() == RobotsValue.DISALLOW) {
                    arrayList.add(RestrictedMethodType.NOINDEX_META_TAG);
                }
                restrictedMethodTypeArray = arrayList.toArray(new RestrictedMethodType[arrayList.size()]);
            }
        }
        return new ResourceRestrictedAuditResult(auditStatusType, restrictedMethodTypeArray);
    }
}

