/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.linkexchange.service;

import com.agilemind.commons.application.data.LinkingDomain;
import com.agilemind.commons.application.data.ScanResult;
import com.agilemind.commons.application.modules.factors.data.DomainStrengthUtil;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.service.IAnchorTextsSummaryWidgetService;
import com.agilemind.commons.application.modules.widget.service.IAnchorUrlsSummaryWidgetService;
import com.agilemind.commons.application.modules.widget.service.ICountryDistributionTldsWidgetService;
import com.agilemind.commons.application.modules.widget.service.IDofollowVsNofollowWidgetService;
import com.agilemind.commons.application.modules.widget.service.IGooglePrDistributionWidgetService;
import com.agilemind.commons.application.modules.widget.service.ILinkingDomainsWidgetService;
import com.agilemind.commons.application.modules.widget.service.IMozPaDaDistributionWidgetService;
import com.agilemind.commons.application.modules.widget.service.ITopAnchorTextIgnoreTypeWidgetService;
import com.agilemind.commons.application.modules.widget.service.ITopAnchorTextWidgetService;
import com.agilemind.commons.application.modules.widget.service.ITopAnchorUrlsWidgetService;
import com.agilemind.commons.application.modules.widget.service.ITopKeywordsWidgetService;
import com.agilemind.commons.application.modules.widget.settings.IFactorTypeSettings;
import com.agilemind.commons.application.modules.widget.util.RecordAnalyzeUtil;
import com.agilemind.commons.application.modules.widget.util.extractor.Extractor;
import com.agilemind.commons.application.modules.widget.util.extractor.FactorValueExtractor;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.GraphPeriod;
import com.agilemind.commons.application.modules.widget.util.to.KeywordsResult;
import com.agilemind.commons.application.modules.widget.util.to.ValuePercent;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.MozAuthorityDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.PRDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.gui.chart.data.XYChartData;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.data.PageInfo;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.agilemind.linkexchange.data.LinkAssistantProject;
import com.agilemind.linkexchange.data.Partner;
import com.agilemind.linkexchange.data.Status;
import com.agilemind.linkexchange.data.StatusList;
import com.agilemind.linkexchange.service.IBacklinkRecord;
import com.agilemind.linkexchange.service.IPartnerRecord;
import com.agilemind.linkexchange.service.IPartnerStatusesWidgetService;
import com.agilemind.linkexchange.service.IPartnerSummaryWidgetService;
import com.agilemind.linkexchange.service.IPartnerWidgetService;
import com.agilemind.linkexchange.service.IPartnersProgressGraphWidgetService;
import com.agilemind.linkexchange.service.IPartnersVerificationWidgetService;
import com.agilemind.linkexchange.service.IPartnersVerificationWidgetService$VerificationStatus;
import com.agilemind.linkexchange.service.LABackLinksWidgetService;
import com.agilemind.linkexchange.service.e;
import com.agilemind.linkexchange.service.g;
import com.agilemind.linkexchange.service.h;
import com.agilemind.linkexchange.service.i;
import com.agilemind.linkexchange.util.BacklinkRecord;
import com.agilemind.linkexchange.util.LALinkingDomainFactory;
import com.agilemind.linkexchange.util.PartnerRecord;
import com.agilemind.linkexchange.util.extractor.LABackLinksUrlExtractor;
import com.agilemind.linkexchange.util.extractor.LAScanResultExtractor;
import com.agilemind.linkexchange.util.extractor.PartnerCountryExtractor;
import com.agilemind.linkexchange.util.to.PartnerStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;

public class PartnerWidgetProjectService
implements IPartnersVerificationWidgetService,
IPartnerWidgetService,
IPartnerStatusesWidgetService,
IPartnersProgressGraphWidgetService,
IPartnerSummaryWidgetService,
IAnchorTextsSummaryWidgetService,
ITopAnchorTextWidgetService,
ITopKeywordsWidgetService,
IAnchorUrlsSummaryWidgetService,
ITopAnchorUrlsWidgetService,
ICountryDistributionTldsWidgetService,
IGooglePrDistributionWidgetService,
IMozPaDaDistributionWidgetService,
IDofollowVsNofollowWidgetService,
LABackLinksWidgetService,
ILinkingDomainsWidgetService,
IFactorTypeSettings,
ITopAnchorTextIgnoreTypeWidgetService {
    private LinkAssistantProject a;
    private List<Partner> b;
    private List<Partner> c;
    private UseSearchEngineFactorList d;
    private static final String e;

    public PartnerWidgetProjectService(IWidgetReportSettings iWidgetReportSettings, LinkAssistantProject linkAssistantProject) {
        this.a = linkAssistantProject;
        this.d = linkAssistantProject.getUseSearchEngineFactorList();
        this.b = RecordAnalyzeUtil.filterByTags((Iterable)((Object)linkAssistantProject.getPartners()), (List)iWidgetReportSettings.getTags());
        this.c = PartnerWidgetProjectService.a(this.b);
    }

    private static List<Partner> a(Iterable<Partner> iterable) {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<Partner> arrayList = new ArrayList<Partner>();
        for (Partner partner : iterable) {
            block8: {
                block7: {
                    ScanResult scanResult = partner.getScanResult();
                    ScanStatus scanStatus = scanResult.getScanStatus();
                    if (scanResult.isYesStatus() || scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) break block7;
                    if (scanStatus != ScanStatus.SCAN_STATUS_NOINDEX_ROBOTS) break block8;
                }
                arrayList.add(partner);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Override
    public UnicodeURL getProjectUrl() {
        return this.a.getDomain();
    }

    @Override
    public BinaryFile getProjectThumbnail() {
        return this.a.getDomainThumbnail();
    }

    @Override
    public String getProjectTitle() {
        ISearchEngineFactor iSearchEngineFactor = this.a.getPopularityHistoryMap().getFactor((FactorType)SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        if (iSearchEngineFactor == null) {
            return null;
        }
        PageInfo pageInfo = (PageInfo)iSearchEngineFactor.getFactorValue();
        if (pageInfo == null) {
            return null;
        }
        return pageInfo.getTitle();
    }

    @Override
    public List<IPartnerRecord> getPartners() {
        return Collections.unmodifiableList(Util.transform(this.b, PartnerRecord::new));
    }

    private List<IPartnerRecord> c() {
        return Collections.unmodifiableList(Util.transform(this.c, PartnerRecord::new));
    }

    @Override
    public int getPartnersCount() {
        return this.b.size();
    }

    @Override
    public double getPartnersCountPercent(int n2) {
        return RecordAnalyzeUtil.getBacklinksPercent((int)n2);
    }

    @Override
    public int getBacklinksCount() {
        return this.c.size();
    }

    @Override
    public Date getReportCreationDate() {
        return new Date();
    }

    @Override
    public double getBacklinksCountPercent(int n2) {
        return RecordAnalyzeUtil.getBacklinksPercent((int)n2);
    }

    @Override
    public int getLinkingDomainsCount() {
        return RecordAnalyzeUtil.getUniqueDomainsCount(this.c, Partner::getBacklinkPage);
    }

    @Override
    public int getIPsCount() {
        return RecordAnalyzeUtil.getUniqueIPsCount(this.c(), (Extractor)new FactorValueExtractor(SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE, PartnerWidgetProjectService::b));
    }

    @Override
    public int getCBlocksCount() {
        return RecordAnalyzeUtil.getUniqueIPsCount(this.c(), (Extractor)new FactorValueExtractor(SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE, PartnerWidgetProjectService::a));
    }

    @Override
    public double getDomainStrength() {
        PopularityHistoryMap popularityHistoryMap = this.a.getPopularityHistoryMap();
        return DomainStrengthUtil.getStrength((IPopularityMap)popularityHistoryMap);
    }

    @Override
    public double getDomainStrengthPercent(double d2) {
        double d3 = d2 == -1.0 ? 0.0 : d2 * 10.0;
        return d3;
    }

    @Override
    public Integer getPartnersDifference(GraphPeriod graphPeriod) {
        Integer n2;
        block12: {
            boolean bl2;
            block14: {
                block13: {
                    boolean bl3 = IPartnersVerificationWidgetService$VerificationStatus.c;
                    int n3 = 0;
                    Date date = graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate();
                    Date date2 = DateUtil.getStartDay((Date)date);
                    NavigableMap<Date, List<Partner>> navigableMap = PartnerWidgetProjectService.b((Iterable<Partner>)((Object)this.a.getPartners()));
                    for (Map.Entry entry : navigableMap.entrySet()) {
                        block11: {
                            Date date3 = (Date)entry.getKey();
                            if (!date2.equals(date3) && !date3.before(date2)) break block11;
                            n3 += ((List)entry.getValue()).size();
                        }
                        if (!bl3) continue;
                    }
                    n2 = n3 != 0 ? Integer.valueOf(this.a.getPartners().size() - n3) : null;
                    if (!LinkAssistantProject.z) break block12;
                    if (!bl3) break block13;
                    bl2 = false;
                    break block14;
                }
                bl2 = true;
            }
            IPartnersVerificationWidgetService$VerificationStatus.c = bl2;
        }
        return n2;
    }

    @Override
    public XYChartData<Number> getPartnersProgressGraphChartData(GraphPeriod graphPeriod) {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        NavigableMap<Date, List<Partner>> navigableMap = PartnerWidgetProjectService.b(this.b);
        XYDataset xYDataset = new XYDataset(UiUtil.PREDEFINED_COLORS[0]);
        int n2 = 0;
        for (Map.Entry entry : navigableMap.entrySet()) {
            xYDataset.put(entry.getKey(), (Object)(n2 += ((List)entry.getValue()).size()));
            if (!bl2) continue;
            boolean bl3 = !LinkAssistantProject.z;
            LinkAssistantProject.z = bl3;
            break;
        }
        Date date = DateUtil.getTimezoneToday();
        if (DateUtil.getStartDay((Date)((Date)navigableMap.lastKey())).before(date)) {
            xYDataset.put((Object)date, (Object)n2);
        }
        XYChartData.Builder builder = new XYChartData.Builder().addSeriesDataset(xYDataset);
        Date date2 = graphPeriod != GraphPeriod.ALL_TIME ? graphPeriod.getDate() : this.a.getEntranceDate();
        return builder.setStartDatePeriod(date2).build();
    }

    private static NavigableMap<Date, List<Partner>> b(Iterable<Partner> iterable) {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        TreeMap<Date, List<Partner>> treeMap = new TreeMap<Date, List<Partner>>();
        for (Partner partner : iterable) {
            Date date = DateUtil.getStartDay((Date)partner.getEnterDate());
            ArrayList<Partner> arrayList = (ArrayList<Partner>)treeMap.get(date);
            if (arrayList == null) {
                arrayList = new ArrayList<Partner>();
                treeMap.put(date, arrayList);
            }
            arrayList.add(partner);
            if (!bl2) continue;
        }
        return treeMap;
    }

    @Override
    public List<PartnerStatus> getStatuses() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<PartnerStatus> arrayList = new ArrayList<PartnerStatus>();
        StatusList statusList = this.a.getStatusList();
        int n2 = this.b.size();
        Iterator iterator = statusList.iterator();
        while (iterator.hasNext()) {
            Status status = (Status)iterator.next();
            List<Partner> list = status.getPartners(this.b);
            arrayList.add(new PartnerStatus(status.getDescription(), new ValuePercent((long)list.size(), MathUtil.getPercent100((double)n2, (double)list.size()))));
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Override
    public double formatStatusPercent(double d2) {
        return d2;
    }

    @Override
    public List<Double> getPartnersVerificationData() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (IPartnersVerificationWidgetService$VerificationStatus iPartnersVerificationWidgetService$VerificationStatus : IPartnersVerificationWidgetService$VerificationStatus.values()) {
            ValuePercent valuePercent = this.getVerificationStatusValuePercent(iPartnersVerificationWidgetService$VerificationStatus);
            arrayList.add(valuePercent.getPercent());
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Override
    public ValuePercent getVerificationStatusValuePercent(IPartnersVerificationWidgetService$VerificationStatus iPartnersVerificationWidgetService$VerificationStatus) {
        List<Partner> list = PartnerWidgetProjectService.a(this.b, iPartnersVerificationWidgetService$VerificationStatus.getScanStatuses());
        return new ValuePercent((long)list.size(), MathUtil.getPercent100((double)this.b.size(), (double)list.size()));
    }

    @Override
    public ValuePercent getScanStatusValuePercent(ScanStatus scanStatus) {
        List<Partner> list = PartnerWidgetProjectService.a(this.b, scanStatus);
        return new ValuePercent((long)list.size(), MathUtil.getPercent100((double)this.b.size(), (double)list.size()));
    }

    private static List<Partner> a(Iterable<Partner> iterable, ScanStatus ... scanStatusArray) {
        return Util.filter(iterable, (Predicate[])new Predicate[]{new e(scanStatusArray)});
    }

    public boolean isFactorTypeActive(SearchEngineFactorType<? extends Comparable> searchEngineFactorType) {
        return this.d.contains(searchEngineFactorType);
    }

    public List<TLDResult> getTLDDistribution(int n2) {
        List list = RecordAnalyzeUtil.calcTldDistribution(this.getRecords(), (Extractor)new LABackLinksUrlExtractor());
        return Util.subList((List)list, (int)n2);
    }

    public List<CountryResult> getCountryDistributions(int n2) {
        List list = RecordAnalyzeUtil.calcCountryDistributions(this.getRecords(), new PartnerCountryExtractor(), (Extractor)new LABackLinksUrlExtractor());
        return Util.subList((List)list, (int)n2);
    }

    public boolean hasRecords() {
        boolean bl2 = !this.c.isEmpty();
        return bl2;
    }

    @Override
    public boolean hasPartners() {
        boolean bl2 = !this.b.isEmpty();
        return bl2;
    }

    @Override
    public boolean hasPartnersWithCheckedAnchors() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        for (Partner partner : this.b) {
            if (partner.getScanResult().getLinkInfo() != null) {
                return true;
            }
            if (!bl2) continue;
        }
        return false;
    }

    public List<PRDistribution> getPagesPRDistributions() {
        return RecordAnalyzeUtil.calcGooglePrDistributions(this.getRecords(), (Extractor)new FactorValueExtractor(SearchEngineFactorsList.PAGE_GOOGLE_PR, (IFactorTypeSettings)this), (Extractor)new LABackLinksUrlExtractor());
    }

    public List<PRDistribution> getDomainsPRDistributions() {
        return RecordAnalyzeUtil.calcGooglePrDistributions(this.getRecords(), (Extractor)new FactorValueExtractor(SearchEngineFactorsList.DOMAIN_GOOGLE_PR, (IFactorTypeSettings)this), (Extractor)new LABackLinksUrlExtractor());
    }

    public List<MozAuthorityDistribution> getPageAuthorityDistribution() {
        return RecordAnalyzeUtil.calcMozPageAuthorityDistribution(this.getRecords(), (Extractor)new LABackLinksUrlExtractor(), (IFactorTypeSettings)this);
    }

    public List<MozAuthorityDistribution> getDomainAuthorityDistribution() {
        return RecordAnalyzeUtil.calcMozDomainAuthorityDistribution(this.getRecords(), (Extractor)new LABackLinksUrlExtractor(), (IFactorTypeSettings)this);
    }

    public DofollowNofollowDistribution getDofollowNofollowDistribution() {
        return RecordAnalyzeUtil.calcDofollowNofollowDistribution(this.getRecords(), (Extractor)new LAScanResultExtractor());
    }

    public HomepageLinksDistribution getHomepageLinksDomainsDistribution() {
        return RecordAnalyzeUtil.calcHomepageLinksDistribution(this.getRecords(), (Extractor)new LABackLinksUrlExtractor());
    }

    @Override
    public List<IBacklinkRecord> getRecords() {
        return Collections.unmodifiableList(Util.transform(this.c, BacklinkRecord::new));
    }

    public List<LinkingDomain> getLinkingDomains() {
        return LALinkingDomainFactory.generatedLinkingDomains(this.getRecords(), this);
    }

    public boolean hasAnchorsRecords() {
        boolean bl2 = !this.c.isEmpty();
        return bl2;
    }

    public boolean hasRecordsWithCheckedAnchors() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        for (Partner partner : this.c) {
            if (partner.getScanResult().getLinkInfo() != null) {
                return true;
            }
            if (!bl2) continue;
        }
        return false;
    }

    public int getUniqueAnchorsCount() {
        return RecordAnalyzeUtil.getUniqueAnchorsCount(this.c, Partner::getScanResult);
    }

    public double getDiversity() {
        return (double)this.getUniqueAnchorsCount() / (double)this.getBacklinksCount();
    }

    public List<Double> getAnchorTypeChartData() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (IAnchorTextsSummaryWidgetService.AnchorType anchorType : IAnchorTextsSummaryWidgetService.AnchorType.values()) {
            ValuePercent valuePercent = this.getAnchorTypeValuePercent(anchorType);
            arrayList.add(valuePercent.getPercent());
            if (!bl2) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValuePercent getAnchorTypeValuePercent(IAnchorTextsSummaryWidgetService.AnchorType anchorType) {
        switch (anchorType) {
            case TEXT: {
                return this.a(new h(null));
            }
            case IMAGE: {
                return this.a(new g(null));
            }
            case UNKNOWN: {
                return this.a(new i(null));
            }
        }
        throw new IllegalArgumentException(e + anchorType);
    }

    private ValuePercent a(Predicate<ScanResult> predicate) {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<Partner> arrayList = new ArrayList<Partner>();
        for (Partner partner : this.c) {
            if (predicate.test(partner.getScanResult())) {
                arrayList.add(partner);
            }
            if (!bl2) continue;
        }
        return new ValuePercent((long)arrayList.size(), MathUtil.getPercent100((double)this.c.size(), (double)arrayList.size()));
    }

    public List<AnchorAltTextResult> getDomainsTopAnchorTexts(int n2) {
        List list = RecordAnalyzeUtil.getDomainsTopAnchorAltTexts(this.c, Partner::getScanResult, Partner::getBacklinkPage, (boolean)true);
        return Util.subList((List)list, (int)n2);
    }

    public List<AnchorAltTextResult> getPagesTopAnchorTexts(int n2) {
        List list = RecordAnalyzeUtil.getPagesTopAnchorAltTexts(this.c, Partner::getScanResult, Partner::getBacklinkPage, (boolean)true);
        return Util.subList((List)list, (int)n2);
    }

    public List<KeywordsResult> getPagesTopKeywords(boolean bl2, int n2) {
        List list = RecordAnalyzeUtil.getPagesTopKeywords(this.c, Partner::getFoundAnchorText, Partner::getBacklinkPage);
        List list2 = bl2 ? Util.subList((List)list, (int)n2) : list;
        return list2;
    }

    public List<KeywordsResult> getDomainsTopKeywords(boolean bl2, int n2) {
        List list = RecordAnalyzeUtil.getDomainsTopKeywords(this.c, Partner::getFoundAnchorText, Partner::getBacklinkPage);
        List list2 = bl2 ? Util.subList((List)list, (int)n2) : list;
        return list2;
    }

    public int getUniqueAnchorUrlsCount() {
        return RecordAnalyzeUtil.getUniqueAnchorUrlsCount(this.c, Partner::getFoundAnchorURL);
    }

    public List<Double> getAnchorUrlsData() {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (IAnchorUrlsSummaryWidgetService.AnchorUrlType anchorUrlType : IAnchorUrlsSummaryWidgetService.AnchorUrlType.values()) {
            ValuePercent valuePercent = this.getAnchorUrlTypeValuePercent(anchorUrlType);
            arrayList.add(valuePercent.getPercent());
            if (!bl2) continue;
        }
        return arrayList;
    }

    public ValuePercent getAnchorUrlTypeValuePercent(IAnchorUrlsSummaryWidgetService.AnchorUrlType anchorUrlType) {
        boolean bl2 = IPartnersVerificationWidgetService$VerificationStatus.c;
        int n2 = 0;
        for (Partner partner : this.c) {
            if (anchorUrlType == this.a(partner.getFoundAnchorURL())) {
                ++n2;
            }
            if (!bl2) continue;
        }
        return new ValuePercent((long)n2, MathUtil.getPercent100((double)this.c.size(), (double)n2));
    }

    private IAnchorUrlsSummaryWidgetService.AnchorUrlType a(UnicodeURL unicodeURL) {
        if (unicodeURL == null) {
            return IAnchorUrlsSummaryWidgetService.AnchorUrlType.UNKNOWN;
        }
        if (UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)this.a.getDomain(), (UnicodeURL)unicodeURL)) {
            return IAnchorUrlsSummaryWidgetService.AnchorUrlType.TO_HOMEPAGE;
        }
        return IAnchorUrlsSummaryWidgetService.AnchorUrlType.TO_OTHER_PAGES;
    }

    public List<AnchorUrlResult> getPagesTopAnchorUrls(int n2) {
        List list = RecordAnalyzeUtil.getPagesTopAnchorUrls(this.c, Partner::getFoundAnchorURL, Partner::getBacklinkPage);
        return Util.subList((List)list, (int)n2);
    }

    public List<AnchorUrlResult> getDomainsTopAnchorUrls(int n2) {
        List list = RecordAnalyzeUtil.getDomainsTopAnchorUrls(this.c, Partner::getFoundAnchorURL, Partner::getBacklinkPage);
        return Util.subList((List)list, (int)n2);
    }

    public List<AnchorAltTextResult> getTopBacklinksAnchorsIgnoreType() {
        List list = RecordAnalyzeUtil.getPagesTopAnchorAltTexts(this.c, Partner::getScanResult, Partner::getBacklinkPage, (boolean)false);
        return Util.subList((List)list, (int)50);
    }

    public Color getProjectColor() {
        return null;
    }

    private static boolean a(SearchEngineFactorType searchEngineFactorType) {
        return true;
    }

    private static boolean b(SearchEngineFactorType searchEngineFactorType) {
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u0017$z6\t5$1\u0019\b!\"~*2;:tx".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c7 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 66;
                            break;
                        }
                        case 1: {
                            n7 = 74;
                            break;
                        }
                        case 2: {
                            n7 = 17;
                            break;
                        }
                        case 3: {
                            n7 = 88;
                            break;
                        }
                        default: {
                            n7 = 102;
                        }
                    }
                    cArray4[n6] = (char)(c7 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        e = new String(cArray).intern();
    }
}

