/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.auditcommon.crawler;

import com.agilemind.auditcommon.crawler.CrawlingUrlIdFactory;
import com.agilemind.auditcommon.crawler.ISiteCrawlingSettings;
import com.agilemind.auditcommon.crawler.ResourceSourceType;
import com.agilemind.auditcommon.crawler.to.UrlID;
import com.agilemind.commons.io.pagereader.AuthorizationRequester;
import com.agilemind.commons.io.proxifier.IProxifiedConnectionSettings;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEngineSettings;
import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.StatusCodeConstants;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CrawlerContext {
    private static final Pattern a;
    private final UnicodeURL b;
    private final IProxifiedConnectionSettings c;
    private final SearchEngineManager d;
    private final CrawlingUrlIdFactory e;
    private final ISearchEngineSettings f;
    private final AuthorizationRequester g;
    private ISiteCrawlingSettings h;

    public CrawlerContext(UnicodeURL unicodeURL, ISiteCrawlingSettings iSiteCrawlingSettings, IProxifiedConnectionSettings iProxifiedConnectionSettings, ISearchEngineSettings iSearchEngineSettings, AuthorizationRequester authorizationRequester, SearchEngineManager searchEngineManager) {
        block5: {
            block6: {
                int n2;
                block4: {
                    n2 = ResourceSourceType.c;
                    this.b = unicodeURL;
                    this.h = iSiteCrawlingSettings;
                    this.c = iProxifiedConnectionSettings;
                    this.f = iSearchEngineSettings;
                    this.g = authorizationRequester;
                    this.d = searchEngineManager;
                    if (!iSiteCrawlingSettings.isIgnoreAllParameters()) break block4;
                    this.e = CrawlingUrlIdFactory.createIgnoreAll();
                    if (n2 == 0) break block5;
                }
                if (!iSiteCrawlingSettings.isIgnoreParametersList()) break block6;
                this.e = CrawlingUrlIdFactory.createIgnoreList(iSiteCrawlingSettings.getIgnoredUrlParameters());
                if (n2 == 0) break block5;
            }
            assert (iSiteCrawlingSettings.isNotIgnoreParameters());
            this.e = CrawlingUrlIdFactory.createNoIgnore();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UnicodeURL createUrlIfPossible(String string, @Nullable Charset charset) {
        if (StringUtil.isEmpty((String)string) || StatusCodeConstants.isBinaryData((String)string) || StatusCodeConstants.isUnsupportedProtocol((String)string) || CrawlerContext.invalidHost(string)) {
            return null;
        }
        try {
            return UnicodeURLUtil.getURL((String)string, (Charset)charset);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean invalidHost(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getAuthority();
            if (string2 == null) return false;
            if (!string2.contains(" ")) return false;
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            Matcher matcher = a.matcher(string);
            boolean bl = matcher.find();
            if (!bl) return false;
            int n2 = string.indexOf("?");
            if (n2 == -1) return true;
            if (matcher.start() <= n2) return true;
            return false;
        }
    }

    public UrlID createId(UnicodeURL unicodeURL) {
        try {
            return this.e.createId(unicodeURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public UnicodeURL toCrawlerUrl(UnicodeURL unicodeURL) {
        return this.createId(unicodeURL).getUrl();
    }

    public UnicodeURL getProjectUrl() {
        return this.b;
    }

    public ISiteCrawlingSettings getCrawlingSettings() {
        return this.h;
    }

    public CrawlerContext setSettings(ISiteCrawlingSettings iSiteCrawlingSettings) {
        this.h = iSiteCrawlingSettings;
        return this;
    }

    public IProxifiedConnectionSettings getConnectionSettings() {
        return this.c;
    }

    public ISearchEngineSettings getSeSettings() {
        return this.f;
    }

    public AuthorizationRequester getAuthorizationRequester() {
        return this.g;
    }

    public SearchEngineManager getSearchEngineManager() {
        return this.d;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "Sz".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 15;
                            break;
                        }
                        case 1: {
                            n7 = 9;
                            break;
                        }
                        case 2: {
                            n7 = 117;
                            break;
                        }
                        case 3: {
                            n7 = 10;
                            break;
                        }
                        default: {
                            n7 = 125;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = Pattern.compile(new String(cArray).intern());
    }
}

