/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.websiteauditor.audit.page.technical.googlepagespeed;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.BooleanResult;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.googlepagespeed.GooglePageSpeedMobile;
import com.agilemind.websiteauditor.audit.page.technical.common.PageTechnicalAuditFactor;
import com.agilemind.websiteauditor.audit.page.technical.googlepagespeed.AbstractListAuditFactor;
import com.agilemind.websiteauditor.audit.page.technical.googlepagespeed.result.ViewportIsConfiguredAuditResult;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;

public class ViewportConfiguredPageAuditFactor
implements PageTechnicalAuditFactor {
    @Override
    public PageAuditResult getResult(WebsiteAuditorPage websiteAuditorPage) {
        BooleanResult booleanResult;
        boolean bl = AbstractListAuditFactor.b;
        SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.GOOGLE_PAGE_SPEED_MOBILE);
        if (searchEngineFactor == null) {
            return new ViewportIsConfiguredAuditResult(AuditStatusType.NOT_YET_CHECKED, 0);
        }
        GooglePageSpeedMobile googlePageSpeedMobile = (GooglePageSpeedMobile)searchEngineFactor.getFactorValue();
        AuditStatusType auditStatusType = AuditStatusType.NOT_YET_CHECKED;
        int n2 = 0;
        if (googlePageSpeedMobile != null && (booleanResult = googlePageSpeedMobile.getConfigureViewport()) != null) {
            switch (booleanResult) {
                case TRUE: {
                    auditStatusType = AuditStatusType.OK;
                    if (!bl) break;
                }
                case FALSE: {
                    auditStatusType = AuditStatusType.WARNING;
                    n2 = googlePageSpeedMobile.getViewPortWidth();
                    if (!bl) break;
                }
                case NA: {
                    auditStatusType = AuditStatusType.N_A;
                }
            }
        }
        return new ViewportIsConfiguredAuditResult(auditStatusType, n2);
    }
}

